/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.util;

import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.documentlibrary.util.Hook;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.service.ServiceContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public abstract class BaseHook
implements Hook {
    private static Log _log = LogFactoryUtil.getLog(BaseHook.class);

    public abstract void addDirectory(long var1, long var3, String var5) throws PortalException, SystemException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, byte[] bytes) throws PortalException, SystemException {
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(bytes);
        try {
            this.addFile(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, serviceContext, is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                _log.error(ioe);
            }
        }
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, File file) throws PortalException, SystemException {
        InputStream is = null;
        try {
            is = new UnsyncBufferedInputStream(new FileInputStream(file));
            this.addFile(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, serviceContext, is);
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException(fileName);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                _log.error(ioe);
            }
        }
    }

    public abstract void addFile(long var1, String var3, long var4, long var6, String var8, long var9, String var11, Date var12, ServiceContext var13, InputStream var14) throws PortalException, SystemException;

    public abstract void checkRoot(long var1) throws SystemException;

    public abstract void deleteDirectory(long var1, String var3, long var4, String var6) throws PortalException, SystemException;

    public abstract void deleteFile(long var1, String var3, long var4, String var6) throws PortalException, SystemException;

    public abstract void deleteFile(long var1, String var3, long var4, String var6, String var7) throws PortalException, SystemException;

    public byte[] getFile(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        byte[] bytes = null;
        try {
            InputStream is = this.getFileAsStream(companyId, repositoryId, fileName);
            bytes = FileUtil.getBytes(is);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
        return bytes;
    }

    public byte[] getFile(long companyId, long repositoryId, String fileName, String versionNumber) throws PortalException, SystemException {
        byte[] bytes = null;
        try {
            InputStream is = this.getFileAsStream(companyId, repositoryId, fileName, versionNumber);
            bytes = FileUtil.getBytes(is);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
        return bytes;
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        return this.getFileAsStream(companyId, repositoryId, fileName, "");
    }

    public abstract InputStream getFileAsStream(long var1, long var3, String var5, String var6) throws PortalException, SystemException;

    public abstract String[] getFileNames(long var1, long var3, String var5) throws PortalException, SystemException;

    public abstract long getFileSize(long var1, long var3, String var5) throws PortalException, SystemException;

    public abstract boolean hasFile(long var1, long var3, String var5, String var6) throws PortalException, SystemException;

    public abstract void move(String var1, String var2) throws SystemException;

    public abstract void reindex(String[] var1) throws SearchException;

    public abstract void updateFile(long var1, String var3, long var4, long var6, long var8, String var10, long var11) throws PortalException, SystemException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, byte[] bytes) throws PortalException, SystemException {
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(bytes);
        try {
            this.updateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, sourceFileName, fileEntryId, properties, modifiedDate, serviceContext, is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                _log.error(ioe);
            }
        }
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, File file) throws PortalException, SystemException {
        InputStream is = null;
        try {
            is = new UnsyncBufferedInputStream(new FileInputStream(file));
            this.updateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, sourceFileName, fileEntryId, properties, modifiedDate, serviceContext, is);
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException(fileName);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                _log.error(ioe);
            }
        }
    }

    public abstract void updateFile(long var1, String var3, long var4, long var6, String var8, String var9, String var10, long var11, String var13, Date var14, ServiceContext var15, InputStream var16) throws PortalException, SystemException;
}

