/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.concurrent.CompeteLatch;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingPortalCache
implements PortalCache {
    private static ThreadLocal<CompeteLatch> _competeLatch = new ThreadLocal();
    private final ConcurrentMap<String, CompeteLatch> _competeLatchMap = new ConcurrentHashMap<String, CompeteLatch>();
    private final PortalCache _portalCache;

    public BlockingPortalCache(PortalCache portalCache) {
        this._portalCache = portalCache;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Collection<Object> get(Collection<String> keys) {
        return this._portalCache.get(keys);
    }

    @Override
    public Object get(String key) {
        CompeteLatch newCompeteLatch;
        CompeteLatch currentCompeteLatch;
        Object obj = this._portalCache.get(key);
        if (obj != null) {
            return obj;
        }
        CompeteLatch lastCompeteLatch = _competeLatch.get();
        if (lastCompeteLatch != null) {
            lastCompeteLatch.done();
            _competeLatch.set(null);
        }
        if ((currentCompeteLatch = (CompeteLatch)this._competeLatchMap.get(key)) == null && (currentCompeteLatch = this._competeLatchMap.putIfAbsent(key, newCompeteLatch = new CompeteLatch())) == null) {
            currentCompeteLatch = newCompeteLatch;
        }
        _competeLatch.set(currentCompeteLatch);
        if (!currentCompeteLatch.compete()) {
            currentCompeteLatch.await();
            _competeLatch.set(null);
            obj = this._portalCache.get(key);
        }
        return obj;
    }

    @Override
    public void put(String key, Object obj) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this._portalCache.put(key, obj);
        CompeteLatch competeLatch = _competeLatch.get();
        if (competeLatch != null) {
            competeLatch.done();
            _competeLatch.set(null);
        }
        this._competeLatchMap.remove(key);
    }

    @Override
    public void put(String key, Object obj, int timeToLive) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this._portalCache.put(key, obj, timeToLive);
        CompeteLatch competeLatch = _competeLatch.get();
        if (competeLatch != null) {
            competeLatch.done();
            _competeLatch.set(null);
        }
        this._competeLatchMap.remove(key);
    }

    @Override
    public void put(String key, Serializable obj) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this._portalCache.put(key, obj);
        CompeteLatch competeLatch = _competeLatch.get();
        if (competeLatch != null) {
            competeLatch.done();
            _competeLatch.set(null);
        }
        this._competeLatchMap.remove(key);
    }

    @Override
    public void put(String key, Serializable obj, int timeToLive) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this._portalCache.put(key, obj, timeToLive);
        CompeteLatch competeLatch = _competeLatch.get();
        if (competeLatch != null) {
            competeLatch.done();
            _competeLatch.set(null);
        }
        this._competeLatchMap.remove(key);
    }

    @Override
    public void remove(String key) {
        this._portalCache.remove(key);
        this._competeLatchMap.remove(key);
    }

    @Override
    public void removeAll() {
        this._portalCache.removeAll();
        this._competeLatchMap.clear();
    }

    @Override
    public void setDebug(boolean debug) {
        this._portalCache.setDebug(debug);
    }
}

