/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache.key;

import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCache;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheKeyGeneratorUtil {
    private static Map<String, CacheKeyGenerator> _cacheKeyGenerators = new HashMap<String, CacheKeyGenerator>();
    private static CacheKeyGenerator _defaultCacheKeyGenerator;

    public static CacheKeyGenerator getCacheKeyGenerator() {
        return CacheKeyGeneratorUtil.getCacheKeyGenerator(null);
    }

    public static CacheKeyGenerator getCacheKeyGenerator(String cacheName) {
        ThreadLocalCache<CacheKeyGenerator> threadLocalCacheKeyGenerators = ThreadLocalCacheManager.getThreadLocalCache(Lifecycle.ETERNAL, CacheKeyGeneratorUtil.class.getName());
        CacheKeyGenerator cacheKeyGenerator = (CacheKeyGenerator)threadLocalCacheKeyGenerators.get(cacheName);
        if (cacheKeyGenerator != null) {
            return cacheKeyGenerator;
        }
        cacheKeyGenerator = _cacheKeyGenerators.get(cacheName);
        if (cacheKeyGenerator == null) {
            cacheKeyGenerator = _defaultCacheKeyGenerator;
        }
        cacheKeyGenerator = cacheKeyGenerator.clone();
        threadLocalCacheKeyGenerators.put(cacheName, cacheKeyGenerator);
        return cacheKeyGenerator;
    }

    public void setCacheKeyGenerators(Map<String, CacheKeyGenerator> cacheKeyGenerators) {
        _cacheKeyGenerators = cacheKeyGenerators;
    }

    public void setDefaultCacheKeyGenerator(CacheKeyGenerator defaultCacheKeyGenerator) {
        _defaultCacheKeyGenerator = defaultCacheKeyGenerator;
    }
}

