/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.MethodWrapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterExecutorUtil {
    private static final String _ADDRESS = "CLUSTER_CONTROL_ADDRESS";
    private static Log _log = LogFactoryUtil.getLog(ClusterExecutorUtil.class);
    private static ClusterExecutor _clusterExecutor;

    public static Map<Address, Future<?>> executeMulticastCall(MethodWrapper methodWrapper) {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return null;
        }
        return _clusterExecutor.executeMulticastCall(methodWrapper);
    }

    public static Future<?> executeUnicastCall(Address address, MethodWrapper methodWrapper) {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return null;
        }
        return _clusterExecutor.executeUnicastCall(address, methodWrapper);
    }

    public static Address getAddress(Message message) {
        return (Address)message.get(_ADDRESS);
    }

    public static ClusterExecutor getClusterExecutor() {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return null;
        }
        return _clusterExecutor;
    }

    public static List<Address> getControlAddresses() {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return Collections.EMPTY_LIST;
        }
        return _clusterExecutor.getControlAddresses();
    }

    public static Address getLocalControlAddresses() {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return null;
        }
        return _clusterExecutor.getLocalControlAddress();
    }

    public static boolean isShortcutLocalMethod() {
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return true;
        }
        return _clusterExecutor.isShortcutLocalMethod();
    }

    public void setClusterExecutor(ClusterExecutor clusterExecutor) {
        _clusterExecutor = clusterExecutor;
    }
}

