/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.util.StringBundler;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLRUCache<K, V> {
    private final AtomicLong _evictCount = new AtomicLong(0L);
    private final Entry<K, V> _headEntry = new Entry<Object, Object>(null, null);
    private final AtomicLong _hitCount = new AtomicLong(0L);
    private final Entry<K, V> _lastEntry = new Entry<Object, Object>(null, null);
    private final int _maxSize;
    private final AtomicLong _missCount = new AtomicLong(0L);
    private final AtomicLong _putCount = new AtomicLong(0L);
    private final Lock _readLock;
    private final ReentrantReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final AtomicInteger _size = new AtomicInteger(0);
    private final Lock _writeLock;

    public ConcurrentLRUCache(int maxSize) {
        this._maxSize = maxSize;
        this._readLock = this._readWriteLock.readLock();
        this._writeLock = this._readWriteLock.writeLock();
        ((Entry)this._headEntry)._nextEntry = (Entry)this._lastEntry;
        ((Entry)this._lastEntry)._previousEntry = (Entry)this._headEntry;
    }

    public long evictCount() {
        return this._evictCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Entry matchEntry = null;
        boolean requiresMove = false;
        this._readLock.lock();
        try {
            matchEntry = ((Entry)this._lastEntry)._previousEntry;
            while (matchEntry != this._headEntry) {
                if (matchEntry._key.equals(key)) {
                    if (matchEntry._nextEntry != this._lastEntry) {
                        requiresMove = true;
                    }
                    this._hitCount.getAndIncrement();
                    Object object = matchEntry._value;
                    return (V)object;
                }
                matchEntry = matchEntry._previousEntry;
            }
        }
        finally {
            this._readLock.unlock();
            if (requiresMove) {
                this._writeLock.lock();
                try {
                    if (matchEntry._key != null) {
                        this._detachEntry(matchEntry);
                        this._insertEntryBefore(this._lastEntry, matchEntry);
                    }
                }
                finally {
                    this._writeLock.unlock();
                }
            }
        }
        this._missCount.getAndIncrement();
        return null;
    }

    public long hitCount() {
        return this._hitCount.get();
    }

    public int maxSize() {
        return this._maxSize;
    }

    public long missCount() {
        return this._missCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        this._putCount.getAndIncrement();
        this._writeLock.lock();
        try {
            Entry currentEntry = ((Entry)this._lastEntry)._previousEntry;
            while (currentEntry != this._headEntry) {
                if (currentEntry._key.equals(key)) {
                    currentEntry._value = value;
                    if (currentEntry._nextEntry != this._lastEntry) {
                        this._detachEntry(currentEntry);
                        this._insertEntryBefore(this._lastEntry, currentEntry);
                    }
                    return;
                }
                currentEntry = currentEntry._previousEntry;
            }
            while (this._size.get() >= this._maxSize) {
                this._removeHeadEntry();
            }
            this._insertEntryBefore(this._lastEntry, new Entry<K, V>(key, value));
            this._size.getAndIncrement();
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public long putCount() {
        return this._putCount.get();
    }

    public int size() {
        return this._size.get();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{evictCount=");
        sb.append(this._evictCount);
        sb.append(", hitCount=");
        sb.append(this._hitCount);
        sb.append(", maxSize=");
        sb.append(this._maxSize);
        sb.append(", missCount=");
        sb.append(this._missCount);
        sb.append(", putCount=");
        sb.append(this._putCount);
        sb.append(", size=");
        sb.append(this._size);
        sb.append("}");
        return sb.toString();
    }

    private void _detachEntry(Entry<K, V> entry) {
        ((Entry)entry)._previousEntry._nextEntry = ((Entry)entry)._nextEntry;
        ((Entry)entry)._nextEntry._previousEntry = ((Entry)entry)._previousEntry;
        ((Entry)entry)._nextEntry = (((Entry)entry)._previousEntry = null);
    }

    private void _insertEntryBefore(Entry<K, V> referenceEntry, Entry<K, V> insertEntry) {
        ((Entry)insertEntry)._previousEntry = ((Entry)referenceEntry)._previousEntry;
        ((Entry)insertEntry)._nextEntry = (Entry)referenceEntry;
        ((Entry)referenceEntry)._previousEntry._nextEntry = (Entry)insertEntry;
        ((Entry)referenceEntry)._previousEntry = (Entry)insertEntry;
    }

    private void _removeHeadEntry() {
        Entry entry = ((Entry)this._headEntry)._nextEntry;
        this._detachEntry(entry);
        entry._key = null;
        entry._value = null;
        this._size.getAndDecrement();
        this._evictCount.getAndIncrement();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V> {
        private K _key;
        private Entry<K, V> _nextEntry;
        private Entry<K, V> _previousEntry;
        private V _value;

        public Entry(K key, V value) {
            this._key = key;
            this._value = value;
        }
    }
}

