/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.search;

import com.liferay.portal.kernel.dao.search.SearchEntry;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.jsp.PageContext;

public class TextSearchEntry
extends SearchEntry {
    private String _name;
    private String _href;
    private String _target;
    private String _title;

    public TextSearchEntry(String align, String valign, String name) {
        this(align, valign, 1, name, null);
    }

    public TextSearchEntry(String align, String valign, int colspan, String name) {
        this(align, valign, colspan, name, null);
    }

    public TextSearchEntry(String align, String valign, String name, String href) {
        this(align, valign, 1, name, href, null, null);
    }

    public TextSearchEntry(String align, String valign, int colspan, String name, String href) {
        this(align, valign, colspan, name, href, null, null);
    }

    public TextSearchEntry(String align, String valign, String name, String href, String target, String title) {
        this(align, valign, 1, name, href, target, title);
    }

    public TextSearchEntry(String align, String valign, int colspan, String name, String href, String target, String title) {
        super(align, valign, colspan);
        this._name = name;
        this._href = href;
        this._target = target;
        this._title = title;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getHref() {
        return this._href;
    }

    public void setHref(String href) {
        this._href = href;
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void print(PageContext pageContext) throws Exception {
        if (this._href == null) {
            pageContext.getOut().print(this._name);
        } else {
            StringBundler sb = new StringBundler();
            sb.append("<a href=\"");
            sb.append(HtmlUtil.escapeAttribute(this._href));
            sb.append("\"");
            if (Validator.isNotNull(this._target)) {
                sb.append(" target=\"");
                sb.append(this._target);
                sb.append("\"");
            }
            if (Validator.isNotNull(this._title)) {
                sb.append(" title=\"");
                sb.append(this._title);
                sb.append("\"");
            }
            sb.append(">");
            sb.append(this._name);
            sb.append("</a>");
            pageContext.getOut().print(sb.toString());
        }
    }

    public Object clone() {
        return new TextSearchEntry(this.getAlign(), this.getValign(), this.getColspan(), this.getName(), this.getHref(), this.getTarget(), this.getTitle());
    }
}

