/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import java.io.IOException;
import java.io.Writer;

public class UnsyncBufferedWriter
extends Writer {
    protected char[] buffer;
    protected int count;
    protected int size;
    protected Writer writer;
    private static int _DEFAULT_BUFFER_SIZE = 8192;
    private static String _LINE_SEPARATOR = System.getProperty("line.separator");

    public UnsyncBufferedWriter(Writer writer) {
        this(writer, _DEFAULT_BUFFER_SIZE);
    }

    public UnsyncBufferedWriter(Writer writer, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size is less than 0");
        }
        this.writer = writer;
        this.size = size;
        this.buffer = new char[size];
    }

    public void close() throws IOException {
        if (this.writer == null) {
            return;
        }
        if (this.count > 0) {
            this.writer.write(this.buffer, 0, this.count);
            this.count = 0;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.buffer = null;
    }

    public void flush() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer is null");
        }
        if (this.count > 0) {
            this.writer.write(this.buffer, 0, this.count);
            this.count = 0;
        }
        this.writer.flush();
    }

    public void newLine() throws IOException {
        this.write(_LINE_SEPARATOR);
    }

    public void write(char[] charArray, int offset, int length) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer is null");
        }
        if (length >= this.size) {
            if (this.count > 0) {
                this.writer.write(this.buffer, 0, this.count);
                this.count = 0;
            }
            this.writer.write(charArray, offset, length);
            return;
        }
        if (this.count > 0 && length > this.size - this.count) {
            this.writer.write(this.buffer, 0, this.count);
            this.count = 0;
        }
        System.arraycopy(charArray, offset, this.buffer, this.count, length);
        this.count += length;
    }

    public void write(int c) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer is null");
        }
        if (this.count >= this.size) {
            this.writer.write(this.buffer);
            this.count = 0;
        }
        this.buffer[this.count++] = (char)c;
    }

    public void write(String string, int offset, int length) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer is null");
        }
        int x = offset;
        int y = offset + length;
        while (x < y) {
            int leftDataSize;
            int leftFreeSpace;
            if (this.count >= this.size) {
                this.writer.write(this.buffer);
                this.count = 0;
            }
            if ((leftFreeSpace = this.size - this.count) > (leftDataSize = y - x)) {
                string.getChars(x, y, this.buffer, this.count);
                this.count += leftDataSize;
                break;
            }
            int copyEnd = x + leftFreeSpace;
            string.getChars(x, copyEnd, this.buffer, this.count);
            this.count += leftFreeSpace;
            x = copyEnd;
        }
    }
}

