/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import com.liferay.portal.kernel.util.StringBundler;
import java.io.Writer;

public class UnsyncStringWriter
extends Writer {
    protected StringBuilder stringBuilder;
    protected StringBundler stringBundler;

    public UnsyncStringWriter() {
        this(true);
    }

    public UnsyncStringWriter(boolean useStringBundler) {
        if (useStringBundler) {
            this.stringBundler = new StringBundler();
        } else {
            this.stringBuilder = new StringBuilder();
        }
    }

    public UnsyncStringWriter(boolean useStringBundler, int initialCapacity) {
        if (useStringBundler) {
            this.stringBundler = new StringBundler(initialCapacity);
        } else {
            this.stringBuilder = new StringBuilder(initialCapacity);
        }
    }

    public UnsyncStringWriter(int initialCapacity) {
        this(true, initialCapacity);
    }

    public UnsyncStringWriter append(char c) {
        this.write(c);
        return this;
    }

    public UnsyncStringWriter append(CharSequence charSequence) {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(((Object)charSequence).toString());
        }
        return this;
    }

    public UnsyncStringWriter append(CharSequence charSequence, int start, int end) {
        if (charSequence == null) {
            charSequence = "null";
        }
        this.write(((Object)charSequence.subSequence(start, end)).toString());
        return this;
    }

    public void close() {
    }

    public void flush() {
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public StringBundler getStringBundler() {
        return this.stringBundler;
    }

    public void reset() {
        if (this.stringBundler != null) {
            this.stringBundler.setIndex(0);
        } else {
            this.stringBuilder.setLength(0);
        }
    }

    public String toString() {
        if (this.stringBundler != null) {
            return this.stringBundler.toString();
        }
        return this.stringBuilder.toString();
    }

    public void write(char[] charArray, int offset, int length) {
        if (length <= 0) {
            return;
        }
        if (this.stringBundler != null) {
            this.stringBundler.append(new String(charArray, offset, length));
        } else {
            this.stringBuilder.append(charArray, offset, length);
        }
    }

    public void write(char[] charArray) {
        this.write(charArray, 0, charArray.length);
    }

    public void write(int c) {
        if (this.stringBundler != null) {
            this.stringBundler.append(String.valueOf((char)c));
        } else {
            this.stringBuilder.append((char)c);
        }
    }

    public void write(String string) {
        if (this.stringBundler != null) {
            this.stringBundler.append(string);
        } else {
            this.stringBuilder.append(string);
        }
    }

    public void write(String string, int offset, int length) {
        if (this.stringBundler != null) {
            this.stringBundler.append(string.substring(offset, offset + length));
        } else {
            this.stringBuilder.append(string.substring(offset, offset + length));
        }
    }
}

