/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jmx;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class MBeanRegistry {
    private static final Log _log = LogFactoryUtil.getLog(MBeanRegistry.class);
    private MBeanServer _mBeanServer;
    private Map<String, ObjectName> _objectNameCache = new HashMap<String, ObjectName>();

    public void destroy() throws Exception {
        for (ObjectName objectName : this._objectNameCache.values()) {
            try {
                this._mBeanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Unable to unregister MBean" + objectName.getCanonicalName(), e);
            }
        }
        this._objectNameCache.clear();
    }

    public ObjectName getObjectName(String objectNameCacheKey) {
        return this._objectNameCache.get(objectNameCacheKey);
    }

    public ObjectInstance register(String objectNameCacheKey, Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance objectInstance = this._mBeanServer.registerMBean(object, objectName);
        this._objectNameCache.put(objectNameCacheKey, objectInstance.getObjectName());
        return objectInstance;
    }

    public void replace(String objectCacheKey, Object object, ObjectName objectName) throws Exception {
        try {
            this.register(objectCacheKey, object, objectName);
        }
        catch (InstanceAlreadyExistsException iaee) {
            this.unregister(objectCacheKey, objectName);
            this.register(objectCacheKey, object, objectName);
        }
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this._mBeanServer = mBeanServer;
    }

    public void unregister(String objectNameCacheKey, ObjectName defaultObjectName) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectName objectName = this._objectNameCache.get(objectNameCacheKey);
        if (objectName == null) {
            this._mBeanServer.unregisterMBean(defaultObjectName);
        } else {
            this._objectNameCache.remove(objectNameCacheKey);
            this._mBeanServer.unregisterMBean(objectName);
        }
    }
}

