/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.ConcurrentHashSet;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDestination
implements Destination {
    private static final int _WORKERS_CORE_SIZE = 2;
    private static final int _WORKERS_MAX_SIZE = 5;
    private static Log _log = LogFactoryUtil.getLog(BaseDestination.class);
    private Set<DestinationEventListener> _destinationEventListeners = new ConcurrentHashSet<DestinationEventListener>();
    private int _maximumQueueSize = -1;
    private Set<MessageListener> _messageListeners = new ConcurrentHashSet<MessageListener>();
    private String _name = "";
    private ThreadPoolExecutor _threadPoolExecutor;
    private int _workersCoreSize = 2;
    private int _workersMaxSize = 5;

    public BaseDestination() {
    }

    public BaseDestination(String name) {
        this(name, 2, 5);
    }

    public BaseDestination(String name, int workersCoreSize, int workersMaxSize) {
        this._name = name;
        this._workersCoreSize = workersCoreSize;
        this._workersMaxSize = workersMaxSize;
        this.open();
    }

    @Override
    public void addDestinationEventListener(DestinationEventListener destinationEventListener) {
        this._destinationEventListeners.add(destinationEventListener);
    }

    public void afterPropertiesSet() {
        if (Validator.isNull(this._name)) {
            throw new IllegalArgumentException("Name is null");
        }
        this.open();
    }

    @Override
    public synchronized void close() {
        this.close(false);
    }

    @Override
    public synchronized void close(boolean force) {
        this.doClose(force);
    }

    @Override
    public void copyDestinationEventListeners(Destination destination) {
        for (DestinationEventListener destinationEventListener : this._destinationEventListeners) {
            destination.addDestinationEventListener(destinationEventListener);
        }
    }

    @Override
    public void copyMessageListeners(Destination destination) {
        for (MessageListener messageListener : this._messageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)messageListener;
            destination.register(invokerMessageListener.getMessageListener(), invokerMessageListener.getClassLoader());
        }
    }

    @Override
    public DestinationStatistics getDestinationStatistics() {
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        destinationStatistics.setActiveThreadCount(this._threadPoolExecutor.getActiveCount());
        destinationStatistics.setCurrentThreadCount(this._threadPoolExecutor.getPoolSize());
        destinationStatistics.setLargestThreadCount(this._threadPoolExecutor.getLargestPoolSize());
        destinationStatistics.setMaxThreadPoolSize(this._threadPoolExecutor.getMaximumPoolSize());
        destinationStatistics.setMinThreadPoolSize(this._threadPoolExecutor.getCorePoolSize());
        destinationStatistics.setPendingMessageCount(this._threadPoolExecutor.getQueue().size());
        destinationStatistics.setSentMessageCount(this._threadPoolExecutor.getCompletedTaskCount());
        return destinationStatistics;
    }

    public int getMaximumQueueSize() {
        return this._maximumQueueSize;
    }

    @Override
    public int getMessageListenerCount() {
        return this._messageListeners.size();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public int getWorkersCoreSize() {
        return this._workersCoreSize;
    }

    public int getWorkersMaxSize() {
        return this._workersMaxSize;
    }

    @Override
    public boolean isRegistered() {
        return this.getMessageListenerCount() > 0;
    }

    @Override
    public synchronized void open() {
        this.doOpen();
    }

    @Override
    public boolean register(MessageListener messageListener) {
        InvokerMessageListener invokerMessageListener = new InvokerMessageListener(messageListener);
        return this.registerMessageListener(invokerMessageListener);
    }

    @Override
    public boolean register(MessageListener messageListener, ClassLoader classloader) {
        InvokerMessageListener invokerMessageListener = new InvokerMessageListener(messageListener, classloader);
        return this.registerMessageListener(invokerMessageListener);
    }

    @Override
    public void removeDestinationEventListener(DestinationEventListener destinationEventListener) {
        this._destinationEventListeners.remove(destinationEventListener);
    }

    @Override
    public void removeDestinationEventListeners() {
        this._destinationEventListeners.clear();
    }

    @Override
    public void send(Message message) {
        if (this._messageListeners.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug("No message listeners for destination " + this.getName());
            }
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        if (threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("Destination " + this.getName() + " is shutdown and cannot " + "receive more messages");
        }
        if (this._maximumQueueSize > -1 && threadPoolExecutor.getQueue().size() > this._maximumQueueSize) {
            throw new IllegalStateException(threadPoolExecutor.getQueue().size() + " messages exceeds the maximum queue size of " + this._maximumQueueSize);
        }
        this.dispatch(this._messageListeners, message);
    }

    public void setMaximumQueueSize(int maximumQueueSize) {
        this._maximumQueueSize = maximumQueueSize;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setWorkersCoreSize(int workersCoreSize) {
        this._workersCoreSize = workersCoreSize;
    }

    public void setWorkersMaxSize(int workersMaxSize) {
        this._workersMaxSize = workersMaxSize;
    }

    @Override
    public boolean unregister(MessageListener messageListener) {
        InvokerMessageListener invokerMessageListener = new InvokerMessageListener(messageListener);
        return this.unregisterMessageListener(invokerMessageListener);
    }

    public boolean unregister(MessageListener messageListener, ClassLoader classloader) {
        InvokerMessageListener invokerMessageListener = new InvokerMessageListener(messageListener, classloader);
        return this.unregisterMessageListener(invokerMessageListener);
    }

    @Override
    public void unregisterMessageListeners() {
        for (MessageListener messageListener : this._messageListeners) {
            this.unregisterMessageListener((InvokerMessageListener)messageListener);
        }
    }

    protected abstract void dispatch(Set<MessageListener> var1, Message var2);

    protected void doClose(boolean force) {
        if (!this._threadPoolExecutor.isShutdown() && !this._threadPoolExecutor.isTerminating()) {
            if (!force) {
                this._threadPoolExecutor.shutdown();
            } else {
                List<Runnable> pendingTasks = this._threadPoolExecutor.shutdownNow();
                if (_log.isInfoEnabled()) {
                    _log.info("The following " + pendingTasks.size() + " tasks " + "were not executed due to shutown: " + pendingTasks);
                }
            }
        }
    }

    protected void doOpen() {
        if (this._threadPoolExecutor == null || this._threadPoolExecutor.isShutdown()) {
            this._threadPoolExecutor = new ThreadPoolExecutor(this._workersCoreSize, this._workersMaxSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(this.getName(), 5));
        }
    }

    protected void fireMessageListenerRegisteredEvent(MessageListener messageListener) {
        for (DestinationEventListener destinationEventListener : this._destinationEventListeners) {
            destinationEventListener.messageListenerRegistered(this.getName(), messageListener);
        }
    }

    protected void fireMessageListenerUnregisteredEvent(MessageListener messageListener) {
        for (DestinationEventListener listener : this._destinationEventListeners) {
            listener.messageListenerUnregistered(this.getName(), messageListener);
        }
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return this._threadPoolExecutor;
    }

    protected boolean registerMessageListener(InvokerMessageListener invokerMessageListener) {
        boolean registered = this._messageListeners.add(invokerMessageListener);
        if (registered) {
            this.fireMessageListenerRegisteredEvent(invokerMessageListener.getMessageListener());
        }
        return registered;
    }

    protected boolean unregisterMessageListener(InvokerMessageListener invokerMessageListener) {
        boolean unregistered = this._messageListeners.remove(invokerMessageListener);
        if (unregistered) {
            this.fireMessageListenerUnregisteredEvent(invokerMessageListener.getMessageListener());
        }
        return unregistered;
    }
}

