/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.BaseDestinationEventListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalDestinationEventListener
extends BaseDestinationEventListener {
    private Set<String> _ignoredDestinations;
    private MessageListener _messageListener;

    public GlobalDestinationEventListener() {
    }

    public GlobalDestinationEventListener(MessageListener messageListener, List<String> ignoredDestinations) {
        this._messageListener = messageListener;
        this._ignoredDestinations = SetUtil.fromList(ignoredDestinations);
    }

    @Override
    public void destinationAdded(Destination destination) {
        if (!this._ignoredDestinations.contains(destination.getName())) {
            destination.register(this._messageListener);
        }
    }

    @Override
    public void destinationRemoved(Destination destination) {
        if (!this._ignoredDestinations.contains(destination.getName())) {
            destination.unregister(this._messageListener);
        }
    }

    public void setIgnoredDestinations(List<String> ignoredDestinations) {
        this._ignoredDestinations = SetUtil.fromList(ignoredDestinations);
    }

    public void setMessageListener(MessageListener messageListener) {
        this._messageListener = messageListener;
    }
}

