/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.messaging.proxy.ExecutingClassLoaders;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MultiClassLoaderProxyRequest
extends ProxyRequest {
    private ClassLoader _clientClassLoaders;

    public MultiClassLoaderProxyRequest(Method method, Object[] arguments) throws Exception {
        super(method, arguments);
        ClassLoader[] classLoaders = this.inspectForClassLoaders(method);
        this._clientClassLoaders = AggregateClassLoader.getAggregateClassLoader(classLoaders);
    }

    public Object execute(Object object) throws Exception {
        Object currentThread;
        ClassLoader contextClassLoader = null;
        if (this._clientClassLoaders != null) {
            currentThread = Thread.currentThread();
            contextClassLoader = ((Thread)currentThread).getContextClassLoader();
            ClassLoader invocationClassLoader = AggregateClassLoader.getAggregateClassLoader(new ClassLoader[]{contextClassLoader, this._clientClassLoaders});
            ((Thread)currentThread).setContextClassLoader(invocationClassLoader);
        }
        try {
            currentThread = super.execute(object);
            return currentThread;
        }
        catch (InvocationTargetException ite) {
            throw new Exception(ite.getTargetException());
        }
        finally {
            if (contextClassLoader != null) {
                Thread currentThread2 = Thread.currentThread();
                currentThread2.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected ClassLoader[] inspectForClassLoaders(Method method) throws Exception {
        Annotation[][] annotationsArray = method.getParameterAnnotations();
        if (annotationsArray == null || annotationsArray.length == 0) {
            return null;
        }
        for (int i = 0; i < annotationsArray.length; ++i) {
            Annotation[] annotations = annotationsArray[i];
            if (annotations == null || annotations.length == 0) continue;
            for (Annotation annotation : annotations) {
                if (!ExecutingClassLoaders.class.isAssignableFrom(annotation.annotationType())) continue;
                return (ClassLoader[])this.getMethodWrapper().getArguments()[i];
            }
        }
        return null;
    }
}

