/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;

public class LiferayPortlet
extends GenericPortlet {
    protected boolean addProcessActionSuccessMessage;
    private static final boolean _PROCESS_PORTLET_REQUEST = true;
    private Map<String, Class<?>> _classesMap = new HashMap();
    private Map<MethodKey, Method> _methodsMap = new HashMap<MethodKey, Method>();

    public void init() throws PortletException {
        super.init();
        this.addProcessActionSuccessMessage = GetterUtil.getBoolean(this.getInitParameter("add-process-action-success-action"), true);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        try {
            if (!this.isProcessActionRequest(actionRequest)) {
                return;
            }
            if (!this.callActionMethod(actionRequest, actionResponse)) {
                return;
            }
            if (!SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                return;
            }
            if (!SessionMessages.isEmpty((PortletRequest)actionRequest)) {
                return;
            }
            this.addSuccessMessage(actionRequest, actionResponse);
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (PortletException pe) {
            Throwable cause = pe.getCause();
            if (this.isSessionErrorException(cause)) {
                SessionErrors.add((PortletRequest)actionRequest, cause.getClass().getName(), (Object)cause);
            }
            throw pe;
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        if (!this.isProcessResourceRequest(resourceRequest)) {
            return;
        }
        super.serveResource(resourceRequest, resourceResponse);
    }

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        if (!this.addProcessActionSuccessMessage) {
            return;
        }
        String successMessage = ParamUtil.getString((PortletRequest)actionRequest, "successMessage");
        SessionMessages.add((PortletRequest)actionRequest, "request_processed", (Object)successMessage);
    }

    protected boolean callActionMethod(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, "javax.portlet.action");
        if (Validator.isNull(actionName)) {
            return false;
        }
        try {
            Method method = MethodCache.get(this._classesMap, this._methodsMap, ((Object)((Object)this)).getClass().getName(), actionName, new Class[]{ActionRequest.class, ActionResponse.class});
            method.invoke((Object)this, actionRequest, actionResponse);
            return true;
        }
        catch (NoSuchMethodException nsme) {
            try {
                super.processAction(actionRequest, actionResponse);
                return true;
            }
            catch (Exception e) {
                throw new PortletException((Throwable)nsme);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause != null) {
                throw new PortletException(cause);
            }
            throw new PortletException((Throwable)ite);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void doAbout(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doAbout method not implemented");
    }

    protected void doConfig(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doConfig method not implemented");
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (!this.isProcessRenderRequest(renderRequest)) {
            renderRequest.setAttribute("PORTLET_DECORATE", (Object)Boolean.FALSE);
            return;
        }
        WindowState windowState = renderRequest.getWindowState();
        if (windowState.equals((Object)WindowState.MINIMIZED)) {
            return;
        }
        PortletMode portletMode = renderRequest.getPortletMode();
        if (portletMode.equals((Object)PortletMode.VIEW)) {
            this.doView(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.ABOUT)) {
            this.doAbout(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.CONFIG)) {
            this.doConfig(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)PortletMode.EDIT)) {
            this.doEdit(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_DEFAULTS)) {
            this.doEditDefaults(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_GUEST)) {
            this.doEditGuest(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)PortletMode.HELP)) {
            this.doHelp(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.PREVIEW)) {
            this.doPreview(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.PRINT)) {
            this.doPrint(renderRequest, renderResponse);
        } else {
            throw new PortletException(portletMode.toString());
        }
    }

    protected void doEditDefaults(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doEditDefaults method not implemented");
    }

    protected void doEditGuest(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doEditGuest method not implemented");
    }

    protected void doPreview(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doPreview method not implemented");
    }

    protected void doPrint(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doPrint method not implemented");
    }

    protected String getRedirect(ActionRequest actionRequest, ActionResponse actionResponse) {
        String redirect = (String)actionRequest.getAttribute("REDIRECT");
        if (Validator.isNull(redirect)) {
            redirect = ParamUtil.getString((PortletRequest)actionRequest, "redirect");
        }
        return redirect;
    }

    protected boolean isProcessActionRequest(ActionRequest actionRequest) {
        return this.isProcessPortletRequest((PortletRequest)actionRequest);
    }

    protected boolean isProcessPortletRequest(PortletRequest portletRequest) {
        return true;
    }

    protected boolean isProcessRenderRequest(RenderRequest renderRequest) {
        return this.isProcessPortletRequest((PortletRequest)renderRequest);
    }

    protected boolean isProcessResourceRequest(ResourceRequest resourceRequest) {
        return this.isProcessPortletRequest((PortletRequest)resourceRequest);
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof PortalException;
    }

    protected void sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        String redirect = this.getRedirect(actionRequest, actionResponse);
        if (Validator.isNotNull(redirect)) {
            actionResponse.sendRedirect(redirect);
        }
    }
}

