/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListenerWrapper;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerRequest;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerEngineUtil {
    private static SchedulerEngineUtil _instance = new SchedulerEngineUtil();
    private SchedulerEngine _schedulerEngine;

    public static List<SchedulerRequest> getScheduledJobs(String groupName) throws SchedulerException {
        return _instance._getScheduledJobs(groupName);
    }

    public static void init(SchedulerEngine defaultScheduler) {
        _instance._init(defaultScheduler);
    }

    public static void schedule(SchedulerEntry schedulerEntry, ClassLoader classLoader) throws SchedulerException {
        MessageListener schedulerEventListener = null;
        try {
            schedulerEventListener = (MessageListener)classLoader.loadClass(schedulerEntry.getEventListenerClass()).newInstance();
            schedulerEventListener = (MessageListener)Proxy.newProxyInstance(classLoader, new Class[]{MessageListener.class}, (InvocationHandler)new ClassLoaderBeanHandler(schedulerEventListener, classLoader));
        }
        catch (Exception e) {
            throw new SchedulerException(e);
        }
        schedulerEventListener = new SchedulerEventMessageListenerWrapper(schedulerEventListener, schedulerEntry.getEventListenerClass());
        schedulerEntry.setEventListener(schedulerEventListener);
        MessageBusUtil.registerMessageListener("liferay/scheduler_dispatch", schedulerEventListener);
        SchedulerEngineUtil.schedule(schedulerEntry.getTrigger(), schedulerEntry.getDescription(), "liferay/scheduler_dispatch", null);
    }

    public static void schedule(Trigger trigger, String description, String destinationName, Message message) throws SchedulerException {
        _instance._schedule(trigger, description, destinationName, message);
    }

    public static void schedule(Trigger trigger, String description, String destinationName, Object payload) throws SchedulerException {
        Message message = new Message();
        message.setPayload(payload);
        _instance._schedule(trigger, description, destinationName, message);
    }

    public static void shutdown() throws SchedulerException {
        _instance._shutdown();
    }

    public static void start() throws SchedulerException {
        _instance._start();
    }

    public static void unschedule(SchedulerEntry schedulerEntry) throws SchedulerException {
        MessageListener schedulerEventListener = schedulerEntry.getEventListener();
        MessageBusUtil.unregisterMessageListener("liferay/scheduler_dispatch", schedulerEventListener);
        SchedulerEngineUtil.unschedule(schedulerEntry.getTrigger());
    }

    public static void unschedule(Trigger trigger) throws SchedulerException {
        _instance._unschedule(trigger);
    }

    private List<SchedulerRequest> _getScheduledJobs(String groupName) throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs(groupName);
    }

    private void _init(SchedulerEngine schedulerEngine) {
        this._schedulerEngine = schedulerEngine;
    }

    private void _schedule(Trigger trigger, String description, String destinationName, Message message) throws SchedulerException {
        this._schedulerEngine.schedule(trigger, description, destinationName, message);
    }

    private void _shutdown() throws SchedulerException {
        this._schedulerEngine.shutdown();
    }

    private void _start() throws SchedulerException {
        this._schedulerEngine.start();
    }

    private void _unschedule(Trigger trigger) throws SchedulerException {
        this._schedulerEngine.unschedule(trigger);
    }
}

