/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler.config;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.config.SchedulingConfigurator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchedulingConfigurator
implements SchedulingConfigurator {
    private static Log _log = LogFactoryUtil.getLog(AbstractSchedulingConfigurator.class);
    private MessageBus _messageBus;
    private SchedulerEngine _schedulerEngine;
    private Map<String, List<SchedulerEntry>> _schedulerEntries = new HashMap<String, List<SchedulerEntry>>();

    @Override
    public void destroy() {
        for (Map.Entry<String, List<SchedulerEntry>> schedulerEntries : this._schedulerEntries.entrySet()) {
            for (SchedulerEntry schedulerEntry : schedulerEntries.getValue()) {
                try {
                    this.destroySchedulerEntry(schedulerEntry);
                }
                catch (Exception e) {
                    _log.error("Unable to unschedule " + schedulerEntry, e);
                }
            }
        }
        this._schedulerEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader operatingClassLoader = this.getOperatingClassloader();
            Thread.currentThread().setContextClassLoader(operatingClassLoader);
            for (Map.Entry<String, List<SchedulerEntry>> schedulerEntries : this._schedulerEntries.entrySet()) {
                String destinationName = schedulerEntries.getKey();
                for (SchedulerEntry schedulerEntry : schedulerEntries.getValue()) {
                    try {
                        this.initSchedulerEntry(destinationName, schedulerEntry);
                    }
                    catch (Exception e) {
                        _log.error("Unable to schedule " + schedulerEntry, e);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }

    @Override
    public void setSchedulerEngine(SchedulerEngine schedulerEngine) {
        this._schedulerEngine = schedulerEngine;
    }

    @Override
    public void setSchedulerEntries(Map<String, List<SchedulerEntry>> schedulerEntries) {
        this._schedulerEntries = schedulerEntries;
    }

    protected abstract ClassLoader getOperatingClassloader();

    protected void destroySchedulerEntry(SchedulerEntry schedulerEntry) throws Exception {
        this._schedulerEngine.unschedule(schedulerEntry.getTrigger());
    }

    protected void initSchedulerEntry(String destinationName, SchedulerEntry schedulerEntry) throws Exception {
        this._messageBus.registerMessageListener(destinationName, schedulerEntry.getEventListener());
        this._schedulerEngine.schedule(schedulerEntry.getTrigger(), schedulerEntry.getDescription(), destinationName, null);
    }
}

