/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.portal.kernel.search.OpenSearchUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import java.util.Date;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseOpenSearchImpl
implements OpenSearch {
    private boolean _enabled = GetterUtil.getBoolean(PropsUtil.get(this.getClass().getName()), true);

    public boolean isEnabled() {
        return this._enabled;
    }

    public abstract String search(HttpServletRequest var1, long var2, long var4, String var6, int var7, int var8, String var9) throws SearchException;

    public String search(HttpServletRequest request, long userId, String keywords, int startPage, int itemsPerPage, String format) throws SearchException {
        return this.search(request, 0L, userId, keywords, startPage, itemsPerPage, format);
    }

    public String search(HttpServletRequest request, String url) throws SearchException {
        try {
            long userId = PortalUtil.getUserId(request);
            if (userId == 0L) {
                long companyId = PortalUtil.getCompanyId(request);
                userId = UserLocalServiceUtil.getDefaultUserId(companyId);
            }
            String keywords = GetterUtil.getString(HttpUtil.getParameter(url, "keywords", false));
            int startPage = GetterUtil.getInteger(HttpUtil.getParameter(url, "p", false), 1);
            int itemsPerPage = GetterUtil.getInteger(HttpUtil.getParameter(url, "c", false), 20);
            String format = GetterUtil.getString(HttpUtil.getParameter(url, "format", false));
            return this.search(request, userId, keywords, startPage, itemsPerPage, format);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    protected void addSearchResult(Element root, long groupId, String title, String link, Date updated, String summary, double score, String format) {
        this.addSearchResult(root, groupId, title, link, updated, summary, new String[0], 0.0, score, format);
    }

    protected void addSearchResult(Element root, long groupId, String title, String link, Date updated, String summary, String[] tags, double ratings, double score, String format) {
        if (format.equals("rss")) {
            this.addSearchResultRSS(root, groupId, title, link, updated, summary, tags, ratings, score);
        } else {
            this.addSearchResultAtom(root, groupId, title, link, updated, summary, tags, ratings, score);
        }
    }

    protected void addSearchResultAtom(Element root, long groupId, String title, String link, Date updated, String summary, String[] tags, double ratings, double score) {
        Element entry = OpenSearchUtil.addElement(root, "entry", 0);
        OpenSearchUtil.addElement(entry, "groupId", 4, groupId);
        OpenSearchUtil.addElement(entry, "title", 0, title);
        Element entryLink = OpenSearchUtil.addElement(entry, "link", 0);
        entryLink.addAttribute("href", link);
        OpenSearchUtil.addElement(entry, "id", 0, "urn:uuid:" + PortalUUIDUtil.generate());
        OpenSearchUtil.addElement(entry, "updated", 0, updated);
        OpenSearchUtil.addElement(entry, "summary", 0, summary);
        OpenSearchUtil.addElement(entry, "tags", 0, StringUtil.merge(tags));
        OpenSearchUtil.addElement(entry, "ratings", 0, ratings);
        OpenSearchUtil.addElement(entry, "score", 2, score);
    }

    protected void addSearchResultRSS(Element root, long groupId, String title, String link, Date updated, String summary, String[] tags, double ratings, double score) {
        Element item = root.addElement("item");
        OpenSearchUtil.addElement(item, "groupId", 4, groupId);
        OpenSearchUtil.addElement(item, "title", 3, title);
        OpenSearchUtil.addElement(item, "link", 3, link);
        OpenSearchUtil.addElement(item, "description", 3, summary);
        OpenSearchUtil.addElement(item, "tags", 3, StringUtil.merge(tags));
        OpenSearchUtil.addElement(item, "ratings", 3, ratings);
        OpenSearchUtil.addElement(item, "score", 2, score);
    }

    protected Object[] addSearchResults(String keywords, int startPage, int itemsPerPage, int total, int start, String title, String searchPath, String format, ThemeDisplay themeDisplay) {
        return this.addSearchResults(new String[0], keywords, startPage, itemsPerPage, total, start, title, searchPath, format, themeDisplay);
    }

    protected Object[] addSearchResults(String[] queryTerms, String keywords, int startPage, int itemsPerPage, int total, int start, String title, String searchPath, String format, ThemeDisplay themeDisplay) {
        int totalPages = 0;
        totalPages = total % itemsPerPage == 0 ? total / itemsPerPage : total / itemsPerPage + 1;
        int previousPage = startPage - 1;
        int nextPage = startPage + 1;
        Document doc = SAXReaderUtil.createDocument();
        if (format.equals("rss")) {
            return this.addSearchResultsRSS(doc, queryTerms, keywords, startPage, itemsPerPage, total, start, totalPages, previousPage, nextPage, title, searchPath, themeDisplay);
        }
        return this.addSearchResultsAtom(doc, queryTerms, keywords, startPage, itemsPerPage, total, start, totalPages, previousPage, nextPage, title, searchPath, themeDisplay);
    }

    protected Object[] addSearchResultsAtom(Document doc, String[] queryTerms, String keywords, int startPage, int itemsPerPage, int total, int start, int totalPages, int previousPage, int nextPage, String title, String searchPath, ThemeDisplay themeDisplay) {
        Element root = doc.addElement("feed");
        root.add(OpenSearchUtil.getNamespace(0));
        root.add(OpenSearchUtil.getNamespace(1));
        root.add(OpenSearchUtil.getNamespace(2));
        OpenSearchUtil.addElement(root, "title", 0, title);
        OpenSearchUtil.addElement(root, "updated", 0, new Date());
        Element author = OpenSearchUtil.addElement(root, "author", 0);
        OpenSearchUtil.addElement(author, "name", 0, themeDisplay.getUserId());
        OpenSearchUtil.addElement(root, "id", 0, "urn:uuid:" + PortalUUIDUtil.generate());
        OpenSearchUtil.addElement(root, "queryTerms", 0, StringUtil.merge(queryTerms, ", "));
        OpenSearchUtil.addElement(root, "totalResults", 1, total);
        OpenSearchUtil.addElement(root, "startIndex", 1, start + 1);
        OpenSearchUtil.addElement(root, "itemsPerPage", 1, itemsPerPage);
        Element query = OpenSearchUtil.addElement(root, "Query", 1);
        query.addAttribute("role", "request");
        query.addAttribute("searchTerms", keywords);
        query.addAttribute("startPage", String.valueOf(startPage));
        String searchURL = themeDisplay.getURLPortal() + searchPath;
        OpenSearchUtil.addLink(root, searchURL, "self", keywords, startPage, itemsPerPage);
        OpenSearchUtil.addLink(root, searchURL, "first", keywords, 1, itemsPerPage);
        if (previousPage > 0) {
            OpenSearchUtil.addLink(root, searchURL, "previous", keywords, previousPage, itemsPerPage);
        }
        if (nextPage <= totalPages) {
            OpenSearchUtil.addLink(root, searchURL, "next", keywords, nextPage, itemsPerPage);
        }
        OpenSearchUtil.addLink(root, searchURL, "last", keywords, totalPages, itemsPerPage);
        Element link = OpenSearchUtil.addElement(root, "link", 0);
        link.addAttribute("rel", "search");
        link.addAttribute("href", searchPath + "_description.xml");
        link.addAttribute("type", "application/opensearchdescription+xml");
        return new Object[]{doc, root};
    }

    protected Object[] addSearchResultsRSS(Document doc, String[] queryTerms, String keywords, int startPage, int itemsPerPage, int total, int start, int totalPages, int previousPage, int nextPage, String title, String searchPath, ThemeDisplay themeDisplay) {
        Element root = doc.addElement("rss");
        root.addAttribute("version", "2.0");
        root.add(SAXReaderUtil.createNamespace("atom", "http://www.w3.org/2005/Atom"));
        root.add(OpenSearchUtil.getNamespace(1));
        root.add(OpenSearchUtil.getNamespace(2));
        Element channel = root.addElement("channel");
        OpenSearchUtil.addElement(channel, "title", 3, title);
        OpenSearchUtil.addElement(channel, "link", 3, themeDisplay.getURLPortal() + searchPath);
        OpenSearchUtil.addElement(channel, "description", 3, title);
        OpenSearchUtil.addElement(channel, "queryTerms", 3, StringUtil.merge(queryTerms, ", "));
        OpenSearchUtil.addElement(channel, "totalResults", 1, total);
        OpenSearchUtil.addElement(channel, "startIndex", 1, start + 1);
        OpenSearchUtil.addElement(channel, "itemsPerPage", 1, itemsPerPage);
        Element query = OpenSearchUtil.addElement(channel, "Query", 1);
        query.addAttribute("role", "request");
        query.addAttribute("searchTerms", keywords);
        query.addAttribute("startPage", String.valueOf(startPage));
        return new Object[]{doc, channel};
    }

    protected PortletURL getPortletURL(HttpServletRequest request, String portletId) throws Exception {
        return this.getPortletURL(request, portletId, 0L);
    }

    protected PortletURL getPortletURL(HttpServletRequest request, String portletId, long groupId) throws Exception {
        Layout layout;
        long plid = LayoutLocalServiceUtil.getDefaultPlid(groupId, false, portletId);
        if (plid == 0L) {
            plid = LayoutLocalServiceUtil.getDefaultPlid(groupId, true, portletId);
        }
        if (plid == 0L && (layout = (Layout)request.getAttribute("LAYOUT")) != null) {
            plid = layout.getPlid();
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create(request, portletId, plid, "RENDER_PHASE");
        portletURL.setWindowState(WindowState.MAXIMIZED);
        portletURL.setPortletMode(PortletMode.VIEW);
        return portletURL;
    }
}

