/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentImpl
implements Document {
    private static final String _DATE_FORMAT_PATTERN = "yyyyMMddHHmmss";
    private static final String _UID_FIELD = "_FIELD_";
    private static final String _UID_PORTLET = "_PORTLET_";
    private Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat("yyyyMMddHHmmss");
    private Map<String, Field> _fields = new HashMap<String, Field>();

    @Override
    public void add(Field field) {
        this._fields.put(field.getName(), field);
    }

    @Override
    public void addDate(String name, Date value) {
        if (value == null) {
            return;
        }
        this.addKeyword(name, this._dateFormat.format(value));
    }

    @Override
    public void addFile(String name, byte[] bytes, String fileExt) {
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(bytes);
        this.addFile(name, is, fileExt);
    }

    @Override
    public void addFile(String name, File file, String fileExt) throws IOException {
        FileInputStream is = new FileInputStream(file);
        this.addFile(name, is, fileExt);
    }

    @Override
    public void addFile(String name, InputStream is, String fileExt) {
        this.addText(name, FileUtil.extractText(is, fileExt));
    }

    @Override
    public void addKeyword(String name, boolean value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Boolean value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, boolean[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Boolean[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, double value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Double value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, double[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Double[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, float value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Float value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, float[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Float[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, int value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, int[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Integer value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Integer[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, long value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Long value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, long[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Long[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, short value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Short value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, short[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Short[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, String value) {
        this.addKeyword(name, value, false);
    }

    @Override
    public void addKeyword(String name, String value, boolean lowerCase) {
        if (lowerCase && Validator.isNotNull(value)) {
            value = value.toLowerCase();
        }
        this._fields.put(name, new Field(name, value, false));
    }

    @Override
    public void addKeyword(String name, String[] values) {
        if (values == null) {
            return;
        }
        this._fields.put(name, new Field(name, values, false));
    }

    @Override
    public void addModifiedDate() {
        this.addModifiedDate(new Date());
    }

    @Override
    public void addModifiedDate(Date modifiedDate) {
        this.addDate("modified", modifiedDate);
    }

    @Override
    public void addText(String name, String value) {
        if (Validator.isNotNull(value)) {
            this._fields.put(name, new Field(name, value, true));
        }
    }

    @Override
    public void addUID(String portletId, long field1) {
        this.addUID(portletId, String.valueOf(field1));
    }

    @Override
    public void addUID(String portletId, long field1, String field2) {
        this.addUID(portletId, String.valueOf(field1), field2);
    }

    @Override
    public void addUID(String portletId, Long field1) {
        this.addUID(portletId, (long)field1);
    }

    @Override
    public void addUID(String portletId, Long field1, String field2) {
        this.addUID(portletId, (long)field1, field2);
    }

    @Override
    public void addUID(String portletId, String field1) {
        this.addUID(portletId, field1, null);
    }

    @Override
    public void addUID(String portletId, String field1, String field2) {
        this.addUID(portletId, field1, field2, null);
    }

    @Override
    public void addUID(String portletId, String field1, String field2, String field3) {
        this.addUID(portletId, field1, field2, field3, null);
    }

    @Override
    public void addUID(String portletId, String field1, String field2, String field3, String field4) {
        String uid = portletId + _UID_PORTLET + field1;
        if (field2 != null) {
            uid = uid + _UID_FIELD + field2;
        }
        if (field3 != null) {
            uid = uid + _UID_FIELD + field3;
        }
        if (field4 != null) {
            uid = uid + _UID_FIELD + field4;
        }
        this.addKeyword("uid", uid);
    }

    @Override
    public String get(String name) {
        Field field = this._fields.get(name);
        if (field == null) {
            return "";
        }
        return field.getValue();
    }

    @Override
    public Date getDate(String name) throws ParseException {
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat(_DATE_FORMAT_PATTERN);
        return dateFormat.parse(this.get(name));
    }

    @Override
    public Map<String, Field> getFields() {
        return this._fields;
    }

    @Override
    public String getUID() {
        Field field = this._fields.get("uid");
        if (field == null) {
            throw new RuntimeException("UID is not set");
        }
        return field.getValue();
    }

    @Override
    public String[] getValues(String name) {
        Field field = this._fields.get(name);
        if (field == null) {
            return new String[]{""};
        }
        return field.getValues();
    }

    public void setFields(Map<String, Field> fields) {
        this._fields = fields;
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        boolean firstField = true;
        for (Field field : this._fields.values()) {
            if (!firstField) {
                sb.append(",");
                sb.append(" ");
            } else {
                firstField = false;
            }
            sb.append(field.getName());
            sb.append("=");
            sb.append(Arrays.toString(field.getValues()));
        }
        sb.append("}");
        return sb.toString();
    }
}

