/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.PortalSearchEngine;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEngineUtil {
    public static final int ALL_POS = -1;
    private static Log _log = LogFactoryUtil.getLog(SearchEngineUtil.class);
    private static PortalSearchEngine _portalSearchEngine;
    private static SearchEngine _searchEngine;
    private static SearchPermissionChecker _searchPermissionChecker;

    public static void addDocument(long companyId, Document document) throws SearchException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Add document " + document.toString());
        }
        _searchPermissionChecker.addPermissionFields(companyId, document);
        _searchEngine.getWriter().addDocument(companyId, document);
    }

    public static void addDocuments(long companyId, Collection<Document> documents) throws SearchException {
        if (SearchEngineUtil.isIndexReadOnly() || documents == null || documents.isEmpty()) {
            return;
        }
        for (Document document : documents) {
            if (_log.isDebugEnabled()) {
                _log.debug("Add document " + document.toString());
            }
            _searchPermissionChecker.addPermissionFields(companyId, document);
        }
        _searchEngine.getWriter().addDocuments(companyId, documents);
    }

    public static void deleteDocument(long companyId, String uid) throws SearchException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        _searchEngine.getWriter().deleteDocument(companyId, uid);
    }

    public static void deleteDocuments(long companyId, Collection<String> uids) throws SearchException {
        if (SearchEngineUtil.isIndexReadOnly() || uids == null || uids.isEmpty()) {
            return;
        }
        _searchEngine.getWriter().deleteDocuments(companyId, uids);
    }

    public static void deletePortletDocuments(long companyId, String portletId) throws SearchException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        _searchEngine.getWriter().deletePortletDocuments(companyId, portletId);
    }

    public static PortalSearchEngine getPortalSearchEngine() {
        return _portalSearchEngine;
    }

    public static SearchEngine getSearchEngine() {
        return _searchEngine;
    }

    public static boolean isIndexReadOnly() {
        return _portalSearchEngine.isIndexReadOnly();
    }

    public static Hits search(long companyId, Query query, int start, int end) throws SearchException {
        if (_log.isDebugEnabled()) {
            _log.debug("Search query " + query.toString());
        }
        return _searchEngine.getSearcher().search(companyId, query, SortFactoryUtil.getDefaultSorts(), start, end);
    }

    public static Hits search(long companyId, Query query, Sort sort, int start, int end) throws SearchException {
        if (_log.isDebugEnabled()) {
            _log.debug("Search query " + query.toString());
        }
        return _searchEngine.getSearcher().search(companyId, query, new Sort[]{sort}, start, end);
    }

    public static Hits search(long companyId, Query query, Sort[] sorts, int start, int end) throws SearchException {
        if (_log.isDebugEnabled()) {
            _log.debug("Search query " + query.toString());
        }
        return _searchEngine.getSearcher().search(companyId, query, sorts, start, end);
    }

    public static Hits search(long companyId, long[] groupIds, long userId, String className, Query query, int start, int end) throws SearchException {
        if (userId > 0L) {
            query = _searchPermissionChecker.getPermissionQuery(companyId, groupIds, userId, className, query);
        }
        return SearchEngineUtil.search(companyId, query, SortFactoryUtil.getDefaultSorts(), start, end);
    }

    public static Hits search(long companyId, long[] groupIds, long userId, String className, Query query, Sort sort, int start, int end) throws SearchException {
        if (userId > 0L) {
            query = _searchPermissionChecker.getPermissionQuery(companyId, groupIds, userId, className, query);
        }
        return SearchEngineUtil.search(companyId, query, sort, start, end);
    }

    public static Hits search(long companyId, long[] groupIds, long userId, String className, Query query, Sort[] sorts, int start, int end) throws SearchException {
        if (userId > 0L) {
            query = _searchPermissionChecker.getPermissionQuery(companyId, groupIds, userId, className, query);
        }
        return SearchEngineUtil.search(companyId, query, sorts, start, end);
    }

    public static void setIndexReadOnly(boolean indexReadOnly) {
        _portalSearchEngine.setIndexReadOnly(indexReadOnly);
    }

    public static void updateDocument(long companyId, Document document) throws SearchException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Document " + document.toString());
        }
        _searchPermissionChecker.addPermissionFields(companyId, document);
        _searchEngine.getWriter().updateDocument(companyId, document);
    }

    public static void updateDocuments(long companyId, Collection<Document> documents) throws SearchException {
        if (SearchEngineUtil.isIndexReadOnly() || documents == null || documents.isEmpty()) {
            return;
        }
        for (Document document : documents) {
            if (_log.isDebugEnabled()) {
                _log.debug("Document " + document.toString());
            }
            _searchPermissionChecker.addPermissionFields(companyId, document);
        }
        _searchEngine.getWriter().updateDocuments(companyId, documents);
    }

    public static void updatePermissionFields(long resourceId) {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        _searchPermissionChecker.updatePermissionFields(resourceId);
    }

    public static void updatePermissionFields(String name, String primKey) {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        _searchPermissionChecker.updatePermissionFields(name, primKey);
    }

    public void setPortalSearchEngine(PortalSearchEngine portalSearchEngine) {
        _portalSearchEngine = portalSearchEngine;
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        _searchEngine = searchEngine;
    }

    public void setSearchPermissionChecker(SearchPermissionChecker searchPermissionChecker) {
        _searchPermissionChecker = searchPermissionChecker;
    }
}

