/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.Header;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HeaderCacheServletResponse
extends HttpServletResponseWrapper {
    private Map<String, List<Header>> _headers = new HashMap<String, List<Header>>();

    public HeaderCacheServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void addDateHeader(String name, long value) {
        List<Header> values = this._headers.get(name);
        if (values == null) {
            values = new ArrayList<Header>();
            this._headers.put(name, values);
        }
        Header header = new Header();
        header.setType(2);
        header.setDateValue(value);
        values.add(header);
        super.addDateHeader(name, value);
    }

    public void addHeader(String name, String value) {
        List<Header> values = this._headers.get(name);
        if (values == null) {
            values = new ArrayList<Header>();
            this._headers.put(name, values);
        }
        Header header = new Header();
        header.setType(3);
        header.setStringValue(value);
        values.add(header);
        if (name.equals("Content-Type")) {
            this.setContentType(value);
        }
        super.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        List<Header> values = this._headers.get(name);
        if (values == null) {
            values = new ArrayList<Header>();
            this._headers.put(name, values);
        }
        Header header = new Header();
        header.setType(1);
        header.setIntValue(value);
        values.add(header);
        super.addIntHeader(name, value);
    }

    public String getHeader(String name) {
        List<Header> values = this._headers.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        Header header = values.get(0);
        return header.toString();
    }

    public Map<String, List<Header>> getHeaders() {
        return this._headers;
    }

    public void setDateHeader(String name, long value) {
        ArrayList<Header> values = new ArrayList<Header>();
        this._headers.put(name, values);
        Header header = new Header();
        header.setType(2);
        header.setDateValue(value);
        values.add(header);
        super.setDateHeader(name, value);
    }

    public void setHeader(String name, String value) {
        ArrayList<Header> values = new ArrayList<Header>();
        this._headers.put(name, values);
        Header header = new Header();
        header.setType(3);
        header.setStringValue(value);
        values.add(header);
        if (name.equals("Content-Type")) {
            this.setContentType(value);
        }
        super.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        ArrayList<Header> values = new ArrayList<Header>();
        this._headers.put(name, values);
        Header header = new Header();
        header.setType(1);
        header.setIntValue(value);
        values.add(header);
        super.setIntHeader(name, value);
    }
}

