/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.servlet.PipingServletOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.PageContext;

public class PipingServletResponse
extends HttpServletResponseWrapper {
    private PrintWriter _printWriter;
    private ServletOutputStream _servletOutputStream;

    public PipingServletResponse(HttpServletResponse response, OutputStream outputStream) {
        super(response);
        this._servletOutputStream = new PipingServletOutputStream(outputStream);
    }

    public PipingServletResponse(HttpServletResponse response, PrintWriter printWriter) {
        super(response);
        this._printWriter = printWriter;
    }

    public PipingServletResponse(HttpServletResponse response, ServletOutputStream servletOutputStream) {
        super(response);
        this._servletOutputStream = servletOutputStream;
    }

    public PipingServletResponse(HttpServletResponse response, Writer writer) {
        super(response);
        this._printWriter = new UnsyncPrintWriter(writer, true);
    }

    public PipingServletResponse(PageContext pageContext) {
        this((HttpServletResponse)pageContext.getResponse(), (Writer)pageContext.getOut());
    }

    public ServletOutputStream getOutputStream() {
        if (this._servletOutputStream == null) {
            throw new IllegalStateException("Servlet output stream is null");
        }
        return this._servletOutputStream;
    }

    public PrintWriter getWriter() {
        if (this._printWriter == null) {
            throw new IllegalStateException("Print writer is null");
        }
        return this._printWriter;
    }
}

