/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalInitable;
import com.liferay.portal.kernel.util.PortalInitableUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class PortalClassLoaderFilter
implements Filter,
PortalInitable {
    private static Log _log = LogFactoryUtil.getLog(PortalClassLoaderFilter.class);
    private Filter _filter;
    private FilterConfig _filterConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            this._filter.destroy();
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            this._filter.doFilter(servletRequest, servletResponse, filterChain);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void init(FilterConfig filterConfig) {
        this._filterConfig = filterConfig;
        PortalInitableUtil.init(this);
    }

    public void portalInit() {
        try {
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            String filterClass = this._filterConfig.getInitParameter("filter-class");
            if (filterClass.startsWith("com.liferay.filters.")) {
                filterClass = StringUtil.replace(filterClass, "com.liferay.filters.", "com.liferay.portal.servlet.filters.");
            }
            this._filter = (Filter)classLoader.loadClass(filterClass).newInstance();
            this._filter.init(this._filterConfig);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }
}

