/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;

public class SerializableSessionAttributeListener
implements HttpSessionAttributeListener {
    private static Log _log = LogFactoryUtil.getLog(SerializableSessionAttributeListener.class);
    private Boolean _requiresSerializable;

    public void attributeAdded(HttpSessionBindingEvent event) {
        String name = event.getName();
        Object value = event.getValue();
        if (!(value instanceof Serializable)) {
            HttpSession session;
            _log.error(value.getClass().getName() + " is not serializable and will prevent this session from " + "being replicated");
            if (this._requiresSerializable == null) {
                session = event.getSession();
                ServletContext servletContext = session.getServletContext();
                this._requiresSerializable = GetterUtil.getBoolean(servletContext.getInitParameter("session-attributes-requires-serializable"));
            }
            if (this._requiresSerializable.booleanValue()) {
                session = event.getSession();
                session.removeAttribute(name);
            }
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        this.attributeAdded(event);
    }
}

