/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class ServletContextPool {
    private static Log _log = LogFactoryUtil.getLog(ServletContextPool.class);
    private static ServletContextPool _instance = new ServletContextPool();
    private Map<String, ServletContext> _servletContextPool = new ConcurrentHashMap<String, ServletContext>();

    public static boolean containsKey(String servletContextName) {
        return _instance._containsKey(servletContextName);
    }

    public static ServletContext get(String servletContextName) {
        return _instance._get(servletContextName);
    }

    public static void put(String servletContextName, ServletContext servletContext) {
        _instance._put(servletContextName, servletContext);
    }

    public static ServletContext remove(String servletContextName) {
        return _instance._remove(servletContextName);
    }

    private ServletContextPool() {
    }

    private boolean _containsKey(String servletContextName) {
        boolean value = this._servletContextPool.containsKey(servletContextName);
        if (_log.isDebugEnabled()) {
            _log.debug("Contains key " + servletContextName + " " + value);
        }
        return value;
    }

    private ServletContext _get(String servletContextName) {
        ServletContext servletContext = this._servletContextPool.get(servletContextName);
        if (_log.isDebugEnabled()) {
            _log.debug("Get " + servletContextName + " " + servletContext);
        }
        return servletContext;
    }

    private void _put(String servletContextName, ServletContext servletContext) {
        if (_log.isDebugEnabled()) {
            _log.debug("Put " + servletContextName + " " + servletContext);
        }
        this._servletContextPool.put(servletContextName, servletContext);
    }

    private ServletContext _remove(String servletContextName) {
        ServletContext servletContext = this._servletContextPool.remove(servletContextName);
        if (_log.isDebugEnabled()) {
            _log.debug("Remove " + servletContextName + " " + servletContext);
        }
        return servletContext;
    }
}

