/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.HeaderCacheServletResponse;
import com.liferay.portal.kernel.servlet.PipingServletOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class StringServletResponse
extends HeaderCacheServletResponse {
    private static Log _log = LogFactoryUtil.getLog(StringServletResponse.class);
    private int _bufferSize;
    private String _contentType;
    private PrintWriter _printWriter;
    private ServletOutputStream _servletOutputStream;
    private int _status = 200;
    private String _string;
    private UnsyncByteArrayOutputStream _unsyncByteArrayOutputStream;
    private UnsyncStringWriter _unsyncStringWriter;

    public StringServletResponse(HttpServletResponse response) {
        super(response);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void flushBuffer() throws IOException {
        if (this._servletOutputStream != null) {
            this._unsyncByteArrayOutputStream.flush();
        } else if (this._printWriter != null) {
            this._unsyncStringWriter.flush();
        }
    }

    public ServletOutputStream getOutputStream() {
        if (this._printWriter != null) {
            throw new IllegalStateException("Cannot obtain OutputStream because Writer is already in use");
        }
        if (this._servletOutputStream == null) {
            this._unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            this._servletOutputStream = new PipingServletOutputStream(this._unsyncByteArrayOutputStream);
        }
        return this._servletOutputStream;
    }

    public int getStatus() {
        return this._status;
    }

    public String getString() {
        if (this._string != null) {
            return this._string;
        }
        if (this._servletOutputStream != null) {
            try {
                this._string = this._unsyncByteArrayOutputStream.toString("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                _log.error(uee, uee);
                this._string = "";
            }
        } else {
            this._string = this._printWriter != null ? this._unsyncStringWriter.toString() : "";
        }
        return this._string;
    }

    public UnsyncByteArrayOutputStream getUnsyncByteArrayOutputStream() {
        return this._unsyncByteArrayOutputStream;
    }

    public PrintWriter getWriter() {
        if (this._servletOutputStream != null) {
            throw new IllegalStateException("Cannot obtain Writer because OutputStream is already in use");
        }
        if (this._printWriter == null) {
            this._unsyncStringWriter = new UnsyncStringWriter();
            this._printWriter = new UnsyncPrintWriter(this._unsyncStringWriter);
        }
        return this._printWriter;
    }

    public boolean isCalledGetOutputStream() {
        return this._servletOutputStream != null;
    }

    public void recycle() {
        this._status = 200;
        this._string = null;
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this._servletOutputStream != null) {
            this._unsyncByteArrayOutputStream.reset();
        } else if (this._printWriter != null) {
            this._unsyncStringWriter.reset();
        }
    }

    public void sendError(int status) throws IOException {
        this._status = status;
        super.sendError(status);
    }

    public void sendError(int status, String msg) throws IOException {
        this._status = status;
        super.sendError(status, msg);
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
        super.setContentType(contentType);
    }

    public void setLocale(Locale locale) {
    }

    public void setStatus(int status) {
        this._status = status;
        super.setStatus(this._status);
    }

    public void setString(String string) {
        this._string = string;
    }
}

