/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.NullWrapper;
import com.liferay.portal.kernel.util.PrimitiveWrapper;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ClassLoaderProxy {
    private static Log _log = LogFactoryUtil.getLog(ClassLoaderProxy.class);
    private Object _obj;
    private ClassLoader _classLoader;
    private String _className;

    public ClassLoaderProxy(Object obj, ClassLoader classLoader) {
        this(obj, obj.getClass().getName(), classLoader);
    }

    public ClassLoaderProxy(Object obj, String className, ClassLoader classLoader) {
        this._obj = obj;
        this._className = className;
        this._classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public Object invoke(String methodName, Object[] args) throws Throwable {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            Method method;
            block13: {
                currentThread.setContextClassLoader(this._classLoader);
                Class<?> classObj = Class.forName(this._className, true, this._classLoader);
                ArrayList<Class> parameterTypes = new ArrayList<Class>();
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    Class argClass = Class.forName(arg.getClass().getName(), true, this._classLoader);
                    if (ClassUtil.isSubclass(argClass, PrimitiveWrapper.class)) {
                        MethodKey methodKey = new MethodKey(argClass.getName(), "getValue", null);
                        Method method2 = MethodCache.get(methodKey);
                        args[i] = method2.invoke(arg, (Object[])null);
                        argClass = (Class)argClass.getField("TYPE").get(arg);
                    }
                    if (ClassUtil.isSubclass(argClass, NullWrapper.class)) {
                        NullWrapper nullWrapper = (NullWrapper)arg;
                        argClass = Class.forName(nullWrapper.getClassName(), true, this._classLoader);
                        args[i] = null;
                    }
                    parameterTypes.add(argClass);
                }
                method = null;
                try {
                    method = classObj.getMethod(methodName, parameterTypes.toArray(new Class[parameterTypes.size()]));
                }
                catch (NoSuchMethodException nsme) {
                    Method[] methods = classObj.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        Class<?>[] methodParameterTypes = methods[i].getParameterTypes();
                        if (!methods[i].getName().equals(methodName) || methodParameterTypes.length != parameterTypes.size()) continue;
                        boolean correctParams = true;
                        for (int j = 0; j < parameterTypes.size(); ++j) {
                            Class<?> b;
                            Class a = (Class)parameterTypes.get(j);
                            if (ClassUtil.isSubclass(a, b = methodParameterTypes[j])) continue;
                            correctParams = false;
                            break;
                        }
                        if (!correctParams) continue;
                        method = methods[i];
                        break;
                    }
                    if (method != null) break block13;
                    throw nsme;
                }
            }
            Object object = method.invoke(this._obj, args);
            return object;
        }
        catch (InvocationTargetException ite) {
            throw this.translateThrowable(ite.getCause(), contextClassLoader);
        }
        catch (Throwable t) {
            _log.error(t, t);
            throw t;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected Throwable translateThrowable(Throwable t1, ClassLoader contextClassLoader) {
        try {
            UnsyncByteArrayOutputStream ubaos = new UnsyncByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(ubaos);
            oos.writeObject(t1);
            oos.flush();
            oos.close();
            UnsyncByteArrayInputStream bais = new UnsyncByteArrayInputStream(ubaos.unsafeGetByteArray(), 0, ubaos.size());
            ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(bais, contextClassLoader);
            t1 = (Throwable)ois.readObject();
            ois.close();
            return t1;
        }
        catch (Throwable t2) {
            _log.error(t2, t2);
            return t2;
        }
    }
}

