/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

public class KMPSearch {
    public static int[] generateNexts(byte[] pattern) {
        int length = pattern.length;
        int[] nexts = new int[length];
        nexts[0] = -1;
        int i = 0;
        int j = -1;
        while (i < length - 1) {
            if (j == -1 || pattern[i] == pattern[j]) {
                nexts[++i] = ++j;
                continue;
            }
            j = nexts[j];
        }
        return nexts;
    }

    public static int[] generateNexts(char[] pattern) {
        int length = pattern.length;
        int[] nexts = new int[length];
        nexts[0] = -1;
        int i = 0;
        int j = -1;
        while (i < length - 1) {
            if (j == -1 || pattern[i] == pattern[j]) {
                nexts[++i] = ++j;
                continue;
            }
            j = nexts[j];
        }
        return nexts;
    }

    public static int search(byte[] text, byte[] pattern) {
        int[] nexts = KMPSearch.generateNexts(pattern);
        return KMPSearch.search(text, 0, text.length, pattern, nexts);
    }

    public static int search(byte[] text, byte[] pattern, int[] nexts) {
        return KMPSearch.search(text, 0, text.length, pattern, nexts);
    }

    public static int search(byte[] text, int offset, byte[] pattern, int[] nexts) {
        return KMPSearch.search(text, offset, text.length - offset, pattern, nexts);
    }

    public static int search(byte[] text, int offset, int length, byte[] pattern, int[] nexts) {
        int patternLength = pattern.length;
        int i = 0;
        int j = 0;
        while (i < length && j < patternLength) {
            if (j == -1 || text[i + offset] == pattern[j]) {
                ++i;
                ++j;
                continue;
            }
            j = nexts[j];
        }
        if (j >= patternLength) {
            return i - patternLength + offset;
        }
        return -1;
    }

    public static int search(char[] text, char[] pattern) {
        int[] nexts = KMPSearch.generateNexts(pattern);
        return KMPSearch.search(text, 0, text.length, pattern, nexts);
    }

    public static int search(char[] text, char[] pattern, int[] nexts) {
        return KMPSearch.search(text, 0, text.length, pattern, nexts);
    }

    public static int search(char[] text, int offset, char[] pattern, int[] nexts) {
        return KMPSearch.search(text, offset, text.length - offset, pattern, nexts);
    }

    public static int search(char[] text, int offset, int length, char[] pattern, int[] nexts) {
        int patternLength = pattern.length;
        int i = 0;
        int j = 0;
        while (i < length && j < patternLength) {
            if (j == -1 || text[i + offset] == pattern[j]) {
                ++i;
                ++j;
                continue;
            }
            j = nexts[j];
        }
        if (j >= patternLength) {
            return i - patternLength + offset;
        }
        return -1;
    }
}

