/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.MethodKey;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCache {
    private static MethodCache _instance = new MethodCache();
    private Map<String, Class<?>> _classesMap = new HashMap();
    private Map<MethodKey, Method> _methodsMap = new HashMap<MethodKey, Method>();

    public static Method get(String className, String methodName) throws ClassNotFoundException, NoSuchMethodException {
        return MethodCache.get(null, null, className, methodName);
    }

    public static Method get(String className, String methodName, Class<?>[] parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
        return MethodCache.get(null, null, className, methodName, parameterTypes);
    }

    public static Method get(Map<String, Class<?>> classesMap, Map<MethodKey, Method> methodsMap, String className, String methodName) throws ClassNotFoundException, NoSuchMethodException {
        return MethodCache.get(className, methodName, new Class[0]);
    }

    public static Method get(Map<String, Class<?>> classesMap, Map<MethodKey, Method> methodsMap, String className, String methodName, Class<?>[] parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
        MethodKey methodKey = new MethodKey(classesMap, methodsMap, className, methodName, parameterTypes);
        return MethodCache.get(methodKey);
    }

    public static Method get(MethodKey methodKey) throws ClassNotFoundException, NoSuchMethodException {
        return _instance._get(methodKey);
    }

    public static Method put(MethodKey methodKey, Method method) {
        return _instance._put(methodKey, method);
    }

    private MethodCache() {
    }

    private Method _get(MethodKey methodKey) throws ClassNotFoundException, NoSuchMethodException {
        Method method;
        Map<MethodKey, Method> methodsMap;
        Map<String, Class<?>> classesMap = methodKey.getClassesMap();
        if (classesMap == null) {
            classesMap = this._classesMap;
        }
        if ((methodsMap = methodKey.getMethodsMap()) == null) {
            methodsMap = this._methodsMap;
        }
        if ((method = methodsMap.get(methodKey)) == null) {
            String className = methodKey.getClassName();
            String methodName = methodKey.getMethodName();
            Class<?>[] types = methodKey.getTypes();
            Class<?> classObj = classesMap.get(className);
            if (classObj == null) {
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                classObj = contextClassLoader.loadClass(className);
                classesMap.put(className, classObj);
            }
            method = classObj.getMethod(methodName, types);
            methodsMap.put(methodKey, method);
        }
        return method;
    }

    private Method _put(MethodKey methodKey, Method method) {
        return this._methodsMap.put(methodKey, method);
    }
}

