/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ProgressTracker {
    public static final String PERCENT = ProgressTracker.class.getName() + "_PERCENT";
    private HttpServletRequest _request;
    private PortletRequest _portletRequest;
    private String _progressId;

    public ProgressTracker(HttpServletRequest request, String progressId) {
        this._request = request;
        this._progressId = progressId;
    }

    public ProgressTracker(PortletRequest portletRequest, String progressId) {
        this._portletRequest = portletRequest;
        this._progressId = progressId;
    }

    public int getProgress() {
        if (this._request != null) {
            HttpSession session = this._request.getSession();
            return (Integer)session.getAttribute(PERCENT + this._progressId);
        }
        PortletSession portletSession = this._portletRequest.getPortletSession();
        return (Integer)portletSession.getAttribute(PERCENT + this._progressId);
    }

    public void start() {
        this.updateProgress(1);
    }

    public void updateProgress(int percentage) {
        if (this._request != null) {
            HttpSession session = this._request.getSession();
            session.setAttribute(PERCENT + this._progressId, (Object)new Integer(percentage));
        } else {
            PortletSession portletSession = this._portletRequest.getPortletSession();
            portletSession.setAttribute(PERCENT + this._progressId, (Object)new Integer(percentage), 1);
        }
    }

    public void finish() {
        if (this._request != null) {
            HttpSession session = this._request.getSession();
            session.removeAttribute(PERCENT + this._progressId);
        } else {
            PortletSession portletSession = this._portletRequest.getPortletSession();
            portletSession.removeAttribute(PERCENT + this._progressId, 1);
        }
    }
}

