/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class ServerDetector {
    public static final String GERONIMO_ID = "geronimo";
    public static final String GLASSFISH_ID = "glassfish";
    public static final String JBOSS_ID = "jboss";
    public static final String JETTY_ID = "jetty";
    public static final String JONAS_ID = "jonas";
    public static final String OC4J_ID = "oc4j";
    public static final String RESIN_ID = "resin";
    public static final String TOMCAT_ID = "tomcat";
    public static final String WEBLOGIC_ID = "weblogic";
    public static final String WEBSPHERE_ID = "websphere";
    private static Log _log = LogFactoryUtil.getLog(ServerDetector.class);
    private static ServerDetector _instance = new ServerDetector();
    private static String _serverId;
    private static Boolean _geronimo;
    private static Boolean _glassfish;
    private static Boolean _jBoss;
    private static Boolean _jetty;
    private static Boolean _jonas;
    private static Boolean _oc4j;
    private static Boolean _resin;
    private static Boolean _tomcat;
    private static Boolean _webLogic;
    private static Boolean _webSphere;

    public static String getServerId() {
        if (_serverId == null) {
            if (ServerDetector.isGeronimo()) {
                _serverId = GERONIMO_ID;
            } else if (ServerDetector.isGlassfish()) {
                _serverId = GLASSFISH_ID;
            } else if (ServerDetector.isJBoss()) {
                _serverId = JBOSS_ID;
            } else if (ServerDetector.isJOnAS()) {
                _serverId = JONAS_ID;
            } else if (ServerDetector.isOC4J()) {
                _serverId = OC4J_ID;
            } else if (ServerDetector.isResin()) {
                _serverId = RESIN_ID;
            } else if (ServerDetector.isWebLogic()) {
                _serverId = WEBLOGIC_ID;
            } else if (ServerDetector.isWebSphere()) {
                _serverId = WEBSPHERE_ID;
            }
            if (ServerDetector.isJetty()) {
                if (_serverId == null) {
                    _serverId = JETTY_ID;
                }
            } else if (ServerDetector.isTomcat() && _serverId == null) {
                _serverId = TOMCAT_ID;
            }
            if (_log.isInfoEnabled()) {
                if (_serverId != null) {
                    _log.info("Detected server " + _serverId);
                } else {
                    _log.info("No server detected");
                }
            }
            if (_serverId == null) {
                throw new RuntimeException("Server is not supported");
            }
        }
        return _serverId;
    }

    public static boolean isGeronimo() {
        if (_geronimo == null) {
            _geronimo = ServerDetector._detect("/org/apache/geronimo/system/main/Daemon.class");
        }
        return _geronimo;
    }

    public static boolean isGlassfish() {
        if (_glassfish == null) {
            String value = System.getProperty("com.sun.aas.instanceRoot");
            _glassfish = value != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return _glassfish;
    }

    public static boolean isJBoss() {
        if (_jBoss == null) {
            _jBoss = ServerDetector._detect("/org/jboss/Main.class");
        }
        return _jBoss;
    }

    public static boolean isJetty() {
        if (_jetty == null) {
            _jetty = ServerDetector._detect("/org/mortbay/jetty/Server.class");
        }
        return _jetty;
    }

    public static boolean isJOnAS() {
        if (_jonas == null && !(_jonas = ServerDetector._detect("/org/objectweb/jonas/server/Server.class")).booleanValue() && System.getProperty("jonas.root") != null) {
            _jonas = Boolean.TRUE;
        }
        return _jonas;
    }

    public static boolean isOC4J() {
        if (_oc4j == null) {
            _oc4j = ServerDetector._detect("oracle.oc4j.util.ClassUtils");
        }
        return _oc4j;
    }

    public static boolean isResin() {
        if (_resin == null) {
            _resin = ServerDetector._detect("/com/caucho/server/resin/Resin.class");
        }
        return _resin;
    }

    public static boolean isSupportsComet() {
        return false;
    }

    public static boolean isTomcat() {
        if (_tomcat == null) {
            _tomcat = ServerDetector._detect("/org/apache/catalina/startup/Bootstrap.class");
        }
        if (_tomcat == null) {
            _tomcat = ServerDetector._detect("/org/apache/catalina/startup/Embedded.class");
        }
        return _tomcat;
    }

    public static boolean isWebLogic() {
        if (_webLogic == null) {
            _webLogic = ServerDetector._detect("/weblogic/Server.class");
        }
        return _webLogic;
    }

    public static boolean isWebSphere() {
        if (_webSphere == null) {
            _webSphere = ServerDetector._detect("/com/ibm/websphere/product/VersionInfo.class");
        }
        return _webSphere;
    }

    private static Boolean _detect(String className) {
        try {
            ClassLoader.getSystemClassLoader().loadClass(className);
            return Boolean.TRUE;
        }
        catch (ClassNotFoundException cnfe) {
            Class<?> classObj = _instance.getClass();
            if (classObj.getResource(className) != null) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    private ServerDetector() {
    }
}

