/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;

public class StringBundler {
    public static final int UNSAFE_CREATE_THRESHOLD = GetterUtil.getInteger(System.getProperty(StringBundler.class.getName() + ".unsafe.create.threshold"));
    private static final int _DEFAULT_ARRAY_CAPACITY = 16;
    private static final String _FALSE = "false";
    private static final String _TRUE = "true";
    private static Log _log = LogFactoryUtil.getLog(StringBundler.class);
    private static Constructor<String> _unsafeStringConstructor;
    private String[] _array;
    private int _arrayIndex;

    public StringBundler() {
        this._array = new String[16];
    }

    public StringBundler(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        this._array = new String[initialCapacity];
    }

    public StringBundler(String s) {
        this._array = new String[16];
        this._array[0] = s;
        this._arrayIndex = 1;
    }

    public StringBundler(String[] stringArray) {
        this(stringArray, 0);
    }

    public StringBundler(String[] stringArray, int extraSpace) {
        this._array = new String[stringArray.length + extraSpace];
        for (int i = 0; i < stringArray.length; ++i) {
            String s = stringArray[i];
            if (s == null || s.length() <= 0) continue;
            this._array[this._arrayIndex++] = s;
        }
    }

    public StringBundler append(boolean b) {
        if (b) {
            return this.append(_TRUE);
        }
        return this.append(_FALSE);
    }

    public StringBundler append(char c) {
        return this.append(String.valueOf(c));
    }

    public StringBundler append(char[] charArray) {
        if (charArray == null) {
            return this.append("null");
        }
        return this.append(new String(charArray));
    }

    public StringBundler append(double d) {
        return this.append(Double.toString(d));
    }

    public StringBundler append(float f) {
        return this.append(Float.toString(f));
    }

    public StringBundler append(int i) {
        return this.append(Integer.toString(i));
    }

    public StringBundler append(long l) {
        return this.append(Long.toString(l));
    }

    public StringBundler append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public StringBundler append(String s) {
        if (s == null) {
            s = "null";
        }
        if (s.length() == 0) {
            return this;
        }
        if (this._arrayIndex >= this._array.length) {
            this.expandCapacity(this._array.length * 2);
        }
        this._array[this._arrayIndex++] = s;
        return this;
    }

    public StringBundler append(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this;
        }
        if (this._array.length - this._arrayIndex < stringArray.length) {
            this.expandCapacity((this._array.length + stringArray.length) * 2);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String s = stringArray[i];
            if (s == null || s.length() <= 0) continue;
            this._array[this._arrayIndex++] = s;
        }
        return this;
    }

    public StringBundler append(StringBundler sb) {
        if (sb == null || sb._arrayIndex == 0) {
            return this;
        }
        if (this._array.length - this._arrayIndex < sb._arrayIndex) {
            this.expandCapacity((this._array.length + sb._arrayIndex) * 2);
        }
        System.arraycopy(sb._array, 0, this._array, this._arrayIndex, sb._arrayIndex);
        this._arrayIndex += sb._arrayIndex;
        return this;
    }

    public int capacity() {
        return this._array.length;
    }

    public int index() {
        return this._arrayIndex;
    }

    public int length() {
        int length = 0;
        for (int i = 0; i < this._arrayIndex; ++i) {
            length += this._array[i].length();
        }
        return length;
    }

    public void setIndex(int newIndex) {
        if (newIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(newIndex);
        }
        if (newIndex > this._array.length) {
            String[] newArray = new String[newIndex];
            System.arraycopy(this._array, 0, newArray, 0, this._arrayIndex);
            this._array = newArray;
        }
        if (this._arrayIndex < newIndex) {
            for (int i = this._arrayIndex; i < newIndex; ++i) {
                this._array[i] = "";
            }
        }
        if (this._arrayIndex > newIndex) {
            for (int i = newIndex; i < this._arrayIndex; ++i) {
                this._array[i] = null;
            }
        }
        this._arrayIndex = newIndex;
    }

    public void setStringAt(String s, int index) {
        if (index < 0 || index >= this._arrayIndex) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this._array[index] = s;
    }

    public String stringAt(int index) {
        if (index < 0 || index >= this._arrayIndex) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this._array[index];
    }

    public String toString() {
        if (this._arrayIndex == 0) {
            return "";
        }
        if (this._arrayIndex == 1) {
            return this._array[0];
        }
        if (this._arrayIndex == 2) {
            return this._array[0].concat(this._array[1]);
        }
        int length = 0;
        for (int i = 0; i < this._arrayIndex; ++i) {
            length += this._array[i].length();
        }
        if (_unsafeStringConstructor != null && length >= UNSAFE_CREATE_THRESHOLD) {
            return this.unsafeCreate(this._array, this._arrayIndex, length);
        }
        if (this._arrayIndex == 3) {
            return this._array[0].concat(this._array[1]).concat(this._array[2]);
        }
        return this.safeCreate(this._array, this._arrayIndex, length);
    }

    public void writeTo(Writer writer) throws IOException {
        for (int i = 0; i < this._arrayIndex; ++i) {
            writer.write(this._array[i]);
        }
    }

    protected void expandCapacity(int newCapacity) {
        String[] newArray = new String[newCapacity];
        System.arraycopy(this._array, 0, newArray, 0, this._arrayIndex);
        this._array = newArray;
    }

    protected String safeCreate(String[] array, int index, int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < index; ++i) {
            sb.append(array[i]);
        }
        return sb.toString();
    }

    protected String unsafeCreate(String[] array, int index, int length) {
        char[] charArray = new char[length];
        int offset = 0;
        for (int i = 0; i < index; ++i) {
            String s = array[i];
            s.getChars(0, s.length(), charArray, offset);
            offset += s.length();
        }
        try {
            return _unsafeStringConstructor.newInstance(0, length, charArray);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        if (UNSAFE_CREATE_THRESHOLD > 0) {
            try {
                _unsafeStringConstructor = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
                _unsafeStringConstructor.setAccessible(true);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }
}

