/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassInvoker;
import com.liferay.portal.kernel.util.StringUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validator {
    private static final int _CHAR_BEGIN = 65;
    private static final int _CHAR_END = 122;
    private static final int _DIGIT_BEGIN = 48;
    private static final int _DIGIT_END = 57;
    private static final char[] _EMAIL_ADDRESS_SPECIAL_CHAR = new char[]{'.', '!', '#', '$', '%', '&', '\'', '*', '+', '-', '/', '=', '?', '^', '_', '`', '{', '|', '}', '~'};
    private static final String _VARIABLE_TERM_BEGIN = "[$";
    private static final String _VARIABLE_TERM_END = "$]";
    private static final String _XML_BEGIN = "<?xml";
    private static final String _XML_EMPTY = "<root />";
    private static Log _log = LogFactoryUtil.getLog(Validator.class);
    private static Pattern _ipAddressPattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
    private static Pattern _variableNamePattern = Pattern.compile("[_a-zA-Z]+[_a-zA-Z0-9]*");

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static boolean isAddress(String address) {
        if (Validator.isNull(address)) {
            return false;
        }
        String[] tokens = address.split("@");
        if (tokens.length != 2) {
            return false;
        }
        for (String token : tokens) {
            for (char c : token.toCharArray()) {
                if (!Character.isWhitespace(c)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAscii(char c) {
        char i = c;
        return i >= ' ' && i <= '~';
    }

    public static boolean isChar(char c) {
        char x = c;
        return x >= 'A' && x <= 'z';
    }

    public static boolean isChar(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (Validator.isChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDate(int month, int day, int year) {
        return Validator.isGregorianDate(month, day, year);
    }

    public static boolean isDigit(char c) {
        char x = c;
        return x >= '0' && x <= '9';
    }

    public static boolean isDigit(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (Validator.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDomain(String domainName) {
        String[] domainNameArray;
        if (Validator.isNull(domainName)) {
            return false;
        }
        if (domainName.length() > 255) {
            return false;
        }
        for (String domainNamePart : domainNameArray = StringUtil.split(domainName, ".")) {
            char[] domainNamePartCharArray = domainNamePart.toCharArray();
            for (int i = 0; i < domainNamePartCharArray.length; ++i) {
                char c = domainNamePartCharArray[i];
                if (i == 0 && c == '-') {
                    return false;
                }
                if (i == domainNamePartCharArray.length - 1 && c == '-') {
                    return false;
                }
                if (Validator.isChar(c) || Validator.isDigit(c) || c == '-') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmailAddress(String emailAddress) {
        Boolean valid;
        block3: {
            valid = null;
            try {
                valid = (Boolean)PortalClassInvoker.invoke("com.liferay.util.mail.InternetAddressUtil", "isValid", emailAddress);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e);
            }
        }
        if (valid == null) {
            return false;
        }
        return valid;
    }

    public static boolean isEmailAddressSpecialChar(char c) {
        for (int i = 0; i < _EMAIL_ADDRESS_SPECIAL_CHAR.length; ++i) {
            if (c != _EMAIL_ADDRESS_SPECIAL_CHAR[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isGregorianDate(int month, int day, int year) {
        if (month < 0 || month > 11) {
            return false;
        }
        int[] months = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (month == 1) {
            int febMax = 28;
            if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                febMax = 29;
            }
            if (day < 1 || day > febMax) {
                return false;
            }
        } else if (day < 1 || day > months[month]) {
            return false;
        }
        return true;
    }

    public static boolean isHex(String s) {
        return !Validator.isNull(s);
    }

    public static boolean isHTML(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        return !(s.indexOf("<html>") == -1 && s.indexOf("<HTML>") == -1 || s.indexOf("</html>") == -1 && s.indexOf("</HTML>") == -1);
    }

    public static boolean isIPAddress(String ipAddress) {
        Matcher matcher = _ipAddressPattern.matcher(ipAddress);
        return matcher.matches();
    }

    public static boolean isJulianDate(int month, int day, int year) {
        if (month < 0 || month > 11) {
            return false;
        }
        int[] months = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (month == 1) {
            int febMax = 28;
            if (year % 4 == 0) {
                febMax = 29;
            }
            if (day < 1 || day > febMax) {
                return false;
            }
        } else if (day < 1 || day > months[month]) {
            return false;
        }
        return true;
    }

    public static boolean isLUHN(String number) {
        if (number == null) {
            return false;
        }
        number = StringUtil.reverse(number);
        int total = 0;
        for (int i = 0; i < number.length(); ++i) {
            int x = 0;
            if ((i + 1) % 2 == 0) {
                x = Integer.parseInt(number.substring(i, i + 1)) * 2;
                if (x >= 10) {
                    String s = String.valueOf(x);
                    x = Integer.parseInt(s.substring(0, 1)) + Integer.parseInt(s.substring(1, 2));
                }
            } else {
                x = Integer.parseInt(number.substring(i, i + 1));
            }
            total += x;
        }
        return total % 10 == 0;
    }

    public static boolean isName(String name) {
        if (Validator.isNull(name)) {
            return false;
        }
        for (char c : name.trim().toCharArray()) {
            if ((Validator.isChar(c) || Character.isWhitespace(c)) && c != ',') continue;
            return false;
        }
        return true;
    }

    public static boolean isNotNull(Object obj) {
        return !Validator.isNull(obj);
    }

    public static boolean isNotNull(Long l) {
        return !Validator.isNull(l);
    }

    public static boolean isNotNull(String s) {
        return !Validator.isNull(s);
    }

    public static boolean isNotNull(Object[] array) {
        return !Validator.isNull(array);
    }

    public static boolean isNull(Object obj) {
        if (obj instanceof Long) {
            return Validator.isNull((Long)obj);
        }
        if (obj instanceof String) {
            return Validator.isNull((String)obj);
        }
        return obj == null;
    }

    public static boolean isNull(Long l) {
        return l == null || l == 0L;
    }

    public static boolean isNull(String s) {
        if (s == null) {
            return true;
        }
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ') continue;
            if (counter > 3) {
                return false;
            }
            if (counter == 0 ? c != 'n' : (counter == 1 ? c != 'u' : (counter == 2 || counter == 3) && c != 'l')) {
                return false;
            }
            ++counter;
        }
        return counter == 0 || counter == 4;
    }

    public static boolean isNull(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNumber(String number) {
        if (Validator.isNull(number)) {
            return false;
        }
        for (char c : number.toCharArray()) {
            if (Validator.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPassword(String password) {
        if (Validator.isNull(password)) {
            return false;
        }
        if (password.length() < 4) {
            return false;
        }
        for (char c : password.toCharArray()) {
            if (Validator.isChar(c) || Validator.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPhoneNumber(String phoneNumber) {
        return Validator.isNumber(StringUtil.extractDigits(phoneNumber));
    }

    public static boolean isUrl(String url) {
        if (Validator.isNotNull(url)) {
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isVariableName(String variableName) {
        if (Validator.isNull(variableName)) {
            return false;
        }
        Matcher matcher = _variableNamePattern.matcher(variableName);
        return matcher.matches();
    }

    public static boolean isVariableTerm(String s) {
        return s.startsWith(_VARIABLE_TERM_BEGIN) && s.endsWith(_VARIABLE_TERM_END);
    }

    public static boolean isWhitespace(char c) {
        char i = c;
        return i == '\u0000' || Character.isWhitespace(c);
    }

    public static boolean isXml(String s) {
        return s.startsWith(_XML_BEGIN) || s.startsWith(_XML_EMPTY);
    }
}

