/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.webdav;

import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import java.io.InputStream;
import java.text.Format;
import java.util.Date;
import java.util.Locale;

public class BaseResourceImpl
implements Resource {
    private static Format _createDateFormatter = FastDateFormatFactoryUtil.getSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private static Format _modifiedDateFormatter = FastDateFormatFactoryUtil.getSimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private String _href;
    private String _displayName;
    private Date _createDate;
    private Date _modifiedDate;
    private long _size;
    private Object _model;
    private String _className;
    private long _primaryKey = -1L;

    public BaseResourceImpl(String parentPath, long name, long displayName) {
        this(parentPath, String.valueOf(name), String.valueOf(displayName));
    }

    public BaseResourceImpl(String parentPath, long name, String displayName) {
        this(parentPath, String.valueOf(name), displayName);
    }

    public BaseResourceImpl(String parentPath, String name, String displayName) {
        this(parentPath, name, displayName, null, null);
    }

    public BaseResourceImpl(String parentPath, String name, String displayName, Date createDate, Date modifiedDate) {
        this(parentPath, name, displayName, createDate, modifiedDate, 0L);
    }

    public BaseResourceImpl(String parentPath, String name, String displayName, Date createDate, Date modifiedDate, long size) {
        this._href = parentPath;
        if (Validator.isNotNull(name)) {
            this._href = this._href + "/" + name;
        }
        this._href = HttpUtil.encodePath(this._href);
        this._displayName = displayName;
        this._createDate = createDate == null ? new Date() : createDate;
        this._modifiedDate = modifiedDate == null ? new Date() : this._createDate;
        this._size = size;
    }

    public String getHREF() {
        return this._href;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public boolean isCollection() {
        return true;
    }

    public boolean isLocked() {
        return false;
    }

    public String getCreateDate() {
        return _createDateFormatter.format(this._createDate);
    }

    public String getModifiedDate() {
        return _modifiedDateFormatter.format(this._modifiedDate);
    }

    public long getSize() {
        return this._size;
    }

    public Object getModel() {
        return this._model;
    }

    public void setModel(Object model) {
        this._model = model;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public long getPrimaryKey() {
        return this._primaryKey;
    }

    public void setPrimaryKey(long primaryKey) {
        this._primaryKey = primaryKey;
    }

    public String getContentType() {
        return "httpd/unix-directory";
    }

    public InputStream getContentAsStream() throws WebDAVException {
        return null;
    }
}

