/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.webdav;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDAVUtil {
    public static final Namespace DAV_URI = SAXReaderUtil.createNamespace("D", "DAV:");
    public static final int SC_MULTI_STATUS = 207;
    public static final int SC_LOCKED = 423;
    public static final String TOKEN_PREFIX = "opaquelocktoken:";
    private static Log _log = LogFactoryUtil.getLog(WebDAVUtil.class);
    private static WebDAVUtil _instance = new WebDAVUtil();
    private Map<String, WebDAVStorage> _storageMap = new TreeMap<String, WebDAVStorage>();

    public static void addStorage(WebDAVStorage storage) {
        _instance._addStorage(storage);
    }

    public static void deleteStorage(WebDAVStorage storage) {
        _instance._deleteStorage(storage);
    }

    public static long getDepth(HttpServletRequest request) {
        String value = GetterUtil.getString(request.getHeader("Depth"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"Depth\" header is " + value);
        }
        if (value.equals("0")) {
            return 0L;
        }
        return -1L;
    }

    public static String getDestination(HttpServletRequest request, String rootPath) {
        String headerDestination = request.getHeader("Destination");
        String[] pathSegments = StringUtil.split(headerDestination, rootPath);
        String destination = pathSegments[pathSegments.length - 1];
        destination = HttpUtil.decodePath(destination);
        if (_log.isDebugEnabled()) {
            _log.debug("Destination " + destination);
        }
        return destination;
    }

    public static long getGroupId(long companyId, String path) throws WebDAVException {
        String[] pathArray = WebDAVUtil.getPathArray(path);
        return WebDAVUtil.getGroupId(companyId, pathArray);
    }

    public static long getGroupId(long companyId, String[] pathArray) throws WebDAVException {
        try {
            if (pathArray.length == 0) {
                return 0L;
            }
            String name = pathArray[0];
            try {
                Group group = GroupLocalServiceUtil.getGroup(companyId, name);
                return group.getGroupId();
            }
            catch (NoSuchGroupException nsge) {
                try {
                    Group group = GroupLocalServiceUtil.getFriendlyURLGroup(companyId, "/" + name);
                    return group.getGroupId();
                }
                catch (NoSuchGroupException nsge2) {
                    try {
                        User user = UserLocalServiceUtil.getUserByScreenName(companyId, name);
                        Group group = user.getGroup();
                        return group.getGroupId();
                    }
                    catch (NoSuchUserException nsue) {
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WebDAVException(e);
        }
        return 0L;
    }

    public static String getLockUuid(HttpServletRequest request) throws WebDAVException {
        String token = "";
        String value = GetterUtil.getString(request.getHeader("If"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"If\" header is " + value);
        }
        if (value.contains("(<DAV:no-lock>)")) {
            if (_log.isWarnEnabled()) {
                _log.warn("Lock tokens can never be <DAV:no-lock>");
            }
            throw new WebDAVException();
        }
        int beg = value.indexOf(TOKEN_PREFIX);
        if (beg >= 0 && (beg += TOKEN_PREFIX.length()) < value.length()) {
            int end = value.indexOf(">", beg);
            token = GetterUtil.getString(value.substring(beg, end));
        }
        return token;
    }

    public static String[] getPathArray(String path) {
        return WebDAVUtil.getPathArray(path, false);
    }

    public static String[] getPathArray(String path, boolean fixTrailing) {
        path = HttpUtil.fixPath(path, true, fixTrailing);
        return StringUtil.split(path, "/");
    }

    public static String getResourceName(String[] pathArray) {
        if (pathArray.length <= 2) {
            return "";
        }
        return pathArray[pathArray.length - 1];
    }

    public static WebDAVStorage getStorage(String token) {
        return _instance._getStorage(token);
    }

    public static Collection<String> getStorageTokens() {
        return _instance._getStorageTokens();
    }

    public static long getTimeout(HttpServletRequest request) {
        int index;
        String TIME_PREFIX = "Second-";
        long timeout = 0L;
        String value = GetterUtil.getString(request.getHeader("Timeout"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"Timeout\" header is " + value);
        }
        if ((index = value.indexOf("Second-")) >= 0 && (index += "Second-".length()) < value.length()) {
            timeout = GetterUtil.getLong(value.substring(index));
        }
        return timeout * 1000L;
    }

    public static boolean isOverwrite(HttpServletRequest request) {
        return _instance._isOverwrite(request);
    }

    private WebDAVUtil() {
    }

    private void _addStorage(WebDAVStorage storage) {
        this._storageMap.put(storage.getToken(), storage);
    }

    private void _deleteStorage(WebDAVStorage storage) {
        if (storage != null) {
            this._storageMap.remove(storage.getToken());
        }
    }

    private WebDAVStorage _getStorage(String token) {
        return this._storageMap.get(token);
    }

    private Collection<String> _getStorageTokens() {
        return this._storageMap.keySet();
    }

    private boolean _isOverwrite(HttpServletRequest request) {
        String value = GetterUtil.getString(request.getHeader("Overwrite"));
        return !value.equalsIgnoreCase("F") && GetterUtil.getBoolean(value);
    }
}

