/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow;

import com.liferay.portal.NoSuchWorkflowDefinitionLinkException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.workflow.WorkflowEngineManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistry;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.service.ServiceContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowHandlerRegistryUtil {
    private static WorkflowHandlerRegistry _workflowHandlerRegistry;

    public static WorkflowHandler getWorkflowHandler(String className) {
        return WorkflowHandlerRegistryUtil.getWorkflowHandlerRegistry().getWorkflowHandler(className);
    }

    public static WorkflowHandlerRegistry getWorkflowHandlerRegistry() {
        return _workflowHandlerRegistry;
    }

    public static List<WorkflowHandler> getWorkflowHandlers() {
        return WorkflowHandlerRegistryUtil.getWorkflowHandlerRegistry().getWorkflowHandlers();
    }

    public static void register(List<WorkflowHandler> workflowHandlers) {
        for (WorkflowHandler workflowHandler : workflowHandlers) {
            WorkflowHandlerRegistryUtil.register(workflowHandler);
        }
    }

    public static void register(WorkflowHandler workflowHandler) {
        WorkflowHandlerRegistryUtil.getWorkflowHandlerRegistry().register(workflowHandler);
    }

    public static void startWorkflowInstance(long companyId, long groupId, long userId, String className, long classPK, Object model, ServiceContext serviceContext) throws PortalException, SystemException {
        if (serviceContext.getWorkflowAction() != 1) {
            return;
        }
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler(className);
        if (workflowHandler == null) {
            throw new WorkflowException("No workflow handler found for " + className);
        }
        int status = 1;
        if (!WorkflowThreadLocal.isEnabled() || !WorkflowEngineManagerUtil.isDeployed()) {
            status = 0;
        }
        HashMap<String, Serializable> workflowContext = new HashMap<String, Serializable>();
        workflowContext.put("companyId", (Serializable)((Object)String.valueOf(companyId)));
        workflowContext.put("groupId", (Serializable)((Object)String.valueOf(groupId)));
        workflowContext.put("userId", (Serializable)((Object)String.valueOf(userId)));
        workflowContext.put("entryClassName", (Serializable)((Object)className));
        workflowContext.put("entryClassPK", (Serializable)((Object)String.valueOf(classPK)));
        workflowContext.put("serviceContext", serviceContext);
        workflowHandler.updateStatus(status, workflowContext);
        if (WorkflowThreadLocal.isEnabled() && WorkflowEngineManagerUtil.isDeployed()) {
            try {
                workflowHandler.startWorkflowInstance(companyId, groupId, userId, classPK, model, workflowContext);
            }
            catch (NoSuchWorkflowDefinitionLinkException nswdle) {
                workflowHandler.updateStatus(0, workflowContext);
            }
        }
    }

    public static void unregister(List<WorkflowHandler> workflowHandlers) {
        for (WorkflowHandler workflowHandler : workflowHandlers) {
            WorkflowHandlerRegistryUtil.unregister(workflowHandler);
        }
    }

    public static void unregister(WorkflowHandler workflowHandler) {
        WorkflowHandlerRegistryUtil.getWorkflowHandlerRegistry().unregister(workflowHandler);
    }

    public static Object updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException, SystemException {
        String className = (String)((Object)workflowContext.get("entryClassName"));
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler(className);
        if (workflowHandler != null) {
            return workflowHandler.updateStatus(status, workflowContext);
        }
        return null;
    }

    public void setWorkflowHandlerRegistry(WorkflowHandlerRegistry workflowHandlerRegistry) {
        _workflowHandlerRegistry = workflowHandlerRegistry;
    }
}

