/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.FullNameGenerator;

public class DefaultFullNameGenerator
implements FullNameGenerator {
    public String getFullName(String firstName, String middleName, String lastName) {
        StringBuilder sb = new StringBuilder();
        sb.append(firstName);
        sb.append(" ");
        if (Validator.isNull(middleName)) {
            sb.append(lastName);
        } else {
            sb.append(middleName);
            sb.append(" ");
            sb.append(lastName);
        }
        return sb.toString();
    }

    public String[] splitFullName(String fullName) {
        String firstName = "";
        String middleName = "";
        String lastName = "";
        if (Validator.isNotNull(fullName)) {
            String[] name = StringUtil.split(fullName, " ");
            firstName = name[0];
            middleName = "";
            lastName = name[name.length - 1];
            if (name.length > 2) {
                for (int i = 1; i < name.length - 1; ++i) {
                    if (Validator.isNull(name[i].trim())) continue;
                    if (i != 1) {
                        middleName = middleName + " ";
                    }
                    middleName = middleName + name[i].trim();
                }
            }
        } else {
            lastName = firstName = GetterUtil.getString(firstName, lastName);
        }
        return new String[]{firstName, middleName, lastName};
    }
}

