/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.model.Layout;
import com.liferay.portal.theme.RequestVars;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavItem
implements Serializable {
    private static final String _VELOCITY_TAGLIB_CLASS = "com.liferay.taglib.util.VelocityTaglib";
    private static final String _VELOCITY_TAGLIB_LAYOUT_ICON_METHOD = "layoutIcon";
    private static final Class<?>[] _VELOCITY_TAGLIB_LAYOUT_ICON_PARAMS = new Class[]{Layout.class};
    private RequestVars _vars;
    private Layout _layout;
    private List<NavItem> _children;

    public static NavItem fromLayout(RequestVars vars, Layout layout) {
        return new NavItem(vars, layout);
    }

    public static List<NavItem> fromLayouts(RequestVars vars, List<Layout> layouts) {
        if (layouts == null) {
            return null;
        }
        ArrayList<NavItem> navItems = new ArrayList<NavItem>(layouts.size());
        for (Layout layout : layouts) {
            navItems.add(NavItem.fromLayout(vars, layout));
        }
        return navItems;
    }

    public NavItem(RequestVars vars, Layout layout) {
        this._vars = vars;
        this._layout = layout;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public boolean isChildSelected() throws PortalException, SystemException {
        ThemeDisplay themeDisplay = this._vars.getThemeDisplay();
        return this._layout.isChildSelected(themeDisplay.isTilesSelectable(), themeDisplay.getLayout());
    }

    public boolean isSelected() {
        ThemeDisplay themeDisplay = this._vars.getThemeDisplay();
        return this._layout.isSelected(themeDisplay.isTilesSelectable(), themeDisplay.getLayout(), this._vars.getAncestorPlid());
    }

    public String getName() {
        return HtmlUtil.escape(this._layout.getName(this._vars.getThemeDisplay().getLocale()));
    }

    public String getTarget() {
        return this._layout.getTarget();
    }

    public String getTitle() {
        return this._layout.getTitle(this._vars.getThemeDisplay().getLocale());
    }

    public String getURL() throws Exception {
        return this.getRegularURL();
    }

    public String getRegularURL() throws Exception {
        return this._layout.getRegularURL(this._vars.getRequest());
    }

    public String getResetMaxStateURL() throws Exception {
        return this._layout.getResetMaxStateURL(this._vars.getRequest());
    }

    public String getResetLayoutURL() throws Exception {
        return this._layout.getResetLayoutURL(this._vars.getRequest());
    }

    public List<NavItem> getChildren() throws Exception {
        if (this._children == null) {
            ThemeDisplay themeDisplay = this._vars.getThemeDisplay();
            List<Layout> layouts = this._layout.getChildren(themeDisplay.getPermissionChecker());
            this._children = NavItem.fromLayouts(this._vars, layouts);
        }
        return this._children;
    }

    public boolean hasChildren() throws Exception {
        return this.getChildren().size() > 0;
    }

    public String icon() throws Exception {
        HttpServletRequest request = this._vars.getRequest();
        Object velocityTaglib = request.getAttribute("VELOCITY_TAGLIB");
        Method method = MethodCache.get(_VELOCITY_TAGLIB_CLASS, _VELOCITY_TAGLIB_LAYOUT_ICON_METHOD, _VELOCITY_TAGLIB_LAYOUT_ICON_PARAMS);
        return (String)method.invoke(velocityTaglib, this._layout);
    }
}

