/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeDisplay
implements Serializable {
    private static Log _log = LogFactoryUtil.getLog(ThemeDisplay.class);
    private Company _company;
    private long _companyGroupId;
    private String _companyLogo = "";
    private int _companyLogoHeight;
    private int _companyLogoWidth;
    private String _realCompanyLogo = "";
    private int _realCompanyLogoHeight;
    private int _realCompanyLogoWidth;
    private Account _account;
    private User _defaultUser;
    private User _user;
    private User _realUser;
    private String _doAsUserId = "";
    private String _doAsUserLanguageId = "";
    private long _doAsGroupId = 0L;
    private long _refererPlid;
    private Contact _contact;
    private String _layoutSetLogo = "";
    private Layout _layout;
    private List<Layout> _layouts;
    private long _plid;
    private LayoutTypePortlet _layoutTypePortlet;
    private Group _scopeGroup;
    private long _scopeGroupId;
    private Group _parentGroup;
    private long _parentGroupId;
    private boolean _signedIn;
    private transient PermissionChecker _permissionChecker;
    private Locale _locale;
    private String _languageId;
    private boolean _i18n;
    private String _i18nLanguageId;
    private String _i18nPath;
    private TimeZone _timeZone;
    private Theme _theme;
    private ColorScheme _colorScheme;
    private boolean _themeCssFastLoad;
    private boolean _themeImagesFastLoad;
    private boolean _themeJsBarebone;
    private boolean _themeJsFastLoad;
    private boolean _freeformLayout;
    private String _serverName;
    private int _serverPort;
    private boolean _secure;
    private String _lifecycle;
    private boolean _lifecycleAction;
    private boolean _lifecycleRender;
    private boolean _lifecycleResource;
    private boolean _stateExclusive;
    private boolean _stateMaximized;
    private boolean _statePopUp;
    private boolean _isolated;
    private boolean _facebook;
    private String _facebookCanvasPageURL;
    private boolean _widget;
    private String _cdnHost = "";
    private String _portalURL = "";
    private String _pathApplet = "";
    private String _pathCms = "";
    private String _pathColorSchemeImages = "";
    private String _pathContext = "";
    private String _pathFlash = "";
    private String _pathFriendlyURLPrivateGroup = "";
    private String _pathFriendlyURLPrivateUser = "";
    private String _pathFriendlyURLPublic = "";
    private String _pathImage = "";
    private String _pathJavaScript = "";
    private String _pathMain = "";
    private String _pathSound = "";
    private String _pathThemeCss = "";
    private String _pathThemeImages = "";
    private String _pathThemeJavaScript = "";
    private String _pathThemeRoot = "";
    private String _pathThemeTemplates = "";
    private boolean _showAddContentIcon;
    private boolean _showAddContentIconPermission;
    private boolean _showControlPanelIcon;
    private boolean _showHomeIcon;
    private boolean _showLayoutTemplatesIcon;
    private boolean _showMyAccountIcon;
    private boolean _showPageSettingsIcon;
    private boolean _showPortalIcon;
    private boolean _showSignInIcon;
    private boolean _showSignOutIcon;
    private boolean _showStagingIcon;
    private String _urlAddContent = "";
    private String _urlControlPanel = "";
    private transient PortletURL _urlCreateAccount = null;
    private String _urlCurrent = "";
    private String _urlHome = "";
    private String _urlLayoutTemplates = "";
    private transient PortletURL _urlMyAccount = null;
    private transient PortletURL _urlPageSettings = null;
    private String _urlPortal = "";
    private transient PortletURL _urlPublishToLive = null;
    private String _urlSignIn = "";
    private String _urlSignOut = "";
    private transient PortletURL _urlUpdateManager = null;
    private String _tilesTitle = "";
    private String _tilesContent = "";
    private boolean _tilesSelectable;
    private boolean _includePortletCssJs;
    private boolean _includeServiceJs;
    private PortletDisplay _portletDisplay = new PortletDisplay();

    public ThemeDisplay() {
        if (_log.isDebugEnabled()) {
            _log.debug("Creating new instance " + this.hashCode());
        }
        this._portletDisplay.setThemeDisplay(this);
    }

    public Company getCompany() {
        return this._company;
    }

    public void setCompany(Company company) throws PortalException, SystemException {
        this._company = company;
        this._companyGroupId = company.getGroup().getGroupId();
        this.setAccount(company.getAccount());
    }

    public long getCompanyId() {
        return this._company.getCompanyId();
    }

    public long getCompanyGroupId() {
        return this._companyGroupId;
    }

    public String getCompanyLogo() {
        return this._companyLogo;
    }

    public void setCompanyLogo(String companyLogo) {
        this._companyLogo = companyLogo;
    }

    public int getCompanyLogoHeight() {
        return this._companyLogoHeight;
    }

    public void setCompanyLogoHeight(int companyLogoHeight) {
        this._companyLogoHeight = companyLogoHeight;
    }

    public int getCompanyLogoWidth() {
        return this._companyLogoWidth;
    }

    public void setCompanyLogoWidth(int companyLogoWidth) {
        this._companyLogoWidth = companyLogoWidth;
    }

    public String getRealCompanyLogo() {
        return this._realCompanyLogo;
    }

    public void setRealCompanyLogo(String realCompanyLogo) {
        this._realCompanyLogo = realCompanyLogo;
    }

    public int getRealCompanyLogoHeight() {
        return this._realCompanyLogoHeight;
    }

    public void setRealCompanyLogoHeight(int realCompanyLogoHeight) {
        this._realCompanyLogoHeight = realCompanyLogoHeight;
    }

    public int getRealCompanyLogoWidth() {
        return this._realCompanyLogoWidth;
    }

    public void setRealCompanyLogoWidth(int realCompanyLogoWidth) {
        this._realCompanyLogoWidth = realCompanyLogoWidth;
    }

    public Account getAccount() {
        return this._account;
    }

    public void setAccount(Account account) {
        this._account = account;
    }

    public User getDefaultUser() throws PortalException, SystemException {
        if (this._defaultUser == null) {
            this._defaultUser = this._company.getDefaultUser();
        }
        return this._defaultUser;
    }

    public long getDefaultUserId() throws PortalException, SystemException {
        return this.getDefaultUser().getUserId();
    }

    public User getUser() {
        return this._user;
    }

    public void setUser(User user) throws PortalException, SystemException {
        this._user = user;
        this.setContact(user.getContact());
    }

    public long getUserId() {
        return this._user.getUserId();
    }

    public User getRealUser() {
        return this._realUser;
    }

    public void setRealUser(User realUser) {
        this._realUser = realUser;
    }

    public long getRealUserId() {
        return this._realUser.getUserId();
    }

    public String getDoAsUserId() {
        return this._doAsUserId;
    }

    public void setDoAsUserId(String doAsUserId) {
        this._doAsUserId = doAsUserId;
    }

    public String getDoAsUserLanguageId() {
        return this._doAsUserLanguageId;
    }

    public void setDoAsUserLanguageId(String doAsUserLanguageId) {
        this._doAsUserLanguageId = doAsUserLanguageId;
    }

    public long getDoAsGroupId() {
        return this._doAsGroupId;
    }

    public void setDoAsGroupId(long doAsGroupId) {
        this._doAsGroupId = doAsGroupId;
    }

    public long getRefererPlid() {
        return this._refererPlid;
    }

    public void setRefererPlid(long refererPlid) {
        this._refererPlid = refererPlid;
    }

    public boolean isImpersonated() {
        return this.getUserId() != this.getRealUserId();
    }

    public Contact getContact() {
        return this._contact;
    }

    public void setContact(Contact contact) {
        this._contact = contact;
    }

    public String getLayoutSetLogo() {
        return this._layoutSetLogo;
    }

    public void setLayoutSetLogo(String layoutSetLogo) {
        this._layoutSetLogo = layoutSetLogo;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public void setLayout(Layout layout) {
        this._layout = layout;
    }

    public List<Layout> getLayouts() {
        return this._layouts;
    }

    public void setLayouts(List<Layout> layouts) {
        this._layouts = layouts;
    }

    public long getPlid() {
        return this._plid;
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public LayoutTypePortlet getLayoutTypePortlet() {
        return this._layoutTypePortlet;
    }

    public void setLayoutTypePortlet(LayoutTypePortlet layoutTypePortlet) {
        this._layoutTypePortlet = layoutTypePortlet;
    }

    public Group getScopeGroup() {
        return this._scopeGroup;
    }

    public long getPortletGroupId() {
        return this.getScopeGroupId();
    }

    public long getScopeGroupId() {
        return this._scopeGroupId;
    }

    public void setScopeGroupId(long scopeGroupId) {
        this._scopeGroupId = scopeGroupId;
        if (this._scopeGroupId > 0L) {
            try {
                this._scopeGroup = GroupLocalServiceUtil.getGroup(this._scopeGroupId);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    public String getScopeGroupName() throws PortalException, SystemException {
        if (this._scopeGroup == null) {
            return "";
        }
        return this._scopeGroup.getDescriptiveName();
    }

    public long getParentGroupId() {
        return this._parentGroupId;
    }

    public void setParentGroupId(long parentGroupId) {
        this._parentGroupId = parentGroupId;
        if (this._parentGroupId > 0L) {
            try {
                this._parentGroup = GroupLocalServiceUtil.getGroup(this._parentGroupId);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    public String getParentGroupName() throws PortalException, SystemException {
        if (this._parentGroup == null) {
            return "";
        }
        return this._parentGroup.getDescriptiveName();
    }

    public boolean isSignedIn() {
        return this._signedIn;
    }

    public void setSignedIn(boolean signedIn) {
        this._signedIn = signedIn;
    }

    public PermissionChecker getPermissionChecker() {
        return this._permissionChecker;
    }

    public void setPermissionChecker(PermissionChecker permissionChecker) {
        this._permissionChecker = permissionChecker;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public String getLanguageId() {
        return this._languageId;
    }

    public void setLanguageId(String languageId) {
        this._languageId = languageId;
    }

    public boolean isI18n() {
        return this._i18n;
    }

    public String getI18nLanguageId() {
        return this._i18nLanguageId;
    }

    public void setI18nLanguageId(String i18nLanguageId) {
        this._i18nLanguageId = i18nLanguageId;
        this._i18n = Validator.isNotNull(i18nLanguageId);
    }

    public String getI18nPath() {
        return this._i18nPath;
    }

    public void setI18nPath(String i18nPath) {
        this._i18nPath = i18nPath;
        this._i18n = Validator.isNotNull(i18nPath);
    }

    public String translate(String key) {
        return LanguageUtil.get(this.getLocale(), key);
    }

    public String translate(String pattern, Object argument) {
        return LanguageUtil.format(this.getLocale(), pattern, argument);
    }

    public String translate(String pattern, Object[] arguments) {
        return LanguageUtil.format(this.getLocale(), pattern, arguments);
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    public Theme getTheme() {
        return this._theme;
    }

    public String getThemeId() {
        return this._theme.getThemeId();
    }

    public ColorScheme getColorScheme() {
        return this._colorScheme;
    }

    public String getColorSchemeId() {
        return this._colorScheme.getColorSchemeId();
    }

    public boolean isWapTheme() {
        return this._theme.isWapTheme();
    }

    public void setLookAndFeel(Theme theme, ColorScheme colorScheme) {
        this.setLookAndFeel(this.getPathContext(), theme, colorScheme);
    }

    public void setLookAndFeel(String contextPath, Theme theme, ColorScheme colorScheme) {
        this._theme = theme;
        this._colorScheme = colorScheme;
        if (theme != null && colorScheme != null) {
            String host;
            String themeContextPath = contextPath;
            if (theme.isWARFile()) {
                themeContextPath = theme.getContextPath();
            }
            if (Validator.isNull(host = this.getCDNHost()) && this.isFacebook()) {
                host = this.getPortalURL();
            }
            this.setPathColorSchemeImages(host + themeContextPath + colorScheme.getColorSchemeImagesPath());
            this.setPathThemeCss(host + themeContextPath + theme.getCssPath());
            this.setPathThemeImages(host + themeContextPath + theme.getImagesPath());
            this.setPathThemeJavaScript(host + themeContextPath + theme.getJavaScriptPath());
            this.setPathThemeRoot(themeContextPath + theme.getRootPath());
            this.setPathThemeTemplates(host + themeContextPath + theme.getTemplatesPath());
        }
    }

    public boolean isThemeCssFastLoad() {
        return this._themeCssFastLoad;
    }

    public void setThemeCssFastLoad(boolean themeCssFastLoad) {
        this._themeCssFastLoad = themeCssFastLoad;
    }

    public boolean isThemeImagesFastLoad() {
        return this._themeImagesFastLoad;
    }

    public void setThemeImagesFastLoad(boolean themeImagesFastLoad) {
        this._themeImagesFastLoad = themeImagesFastLoad;
    }

    public boolean isThemeJsBarebone() {
        return this._themeJsBarebone;
    }

    public void setThemeJsBarebone(boolean themeJsBarebone) {
        this._themeJsBarebone = themeJsBarebone;
    }

    public boolean isThemeJsFastLoad() {
        return this._themeJsFastLoad;
    }

    public void setThemeJsFastLoad(boolean themeJsFastLoad) {
        this._themeJsFastLoad = themeJsFastLoad;
    }

    public boolean isFreeformLayout() {
        return this._freeformLayout;
    }

    public void setFreeformLayout(boolean freeformLayout) {
        this._freeformLayout = freeformLayout;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public void setServerPort(int serverPort) {
        this._serverPort = serverPort;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public String getLifecycle() {
        return this._lifecycle;
    }

    public void setLifecycle(String lifecycle) {
        this._lifecycle = lifecycle;
    }

    public boolean isLifecycleAction() {
        return this._lifecycleAction;
    }

    public void setLifecycleAction(boolean lifecycleAction) {
        this._lifecycleAction = lifecycleAction;
    }

    public boolean isLifecycleRender() {
        return this._lifecycleRender;
    }

    public void setLifecycleRender(boolean lifecycleRender) {
        this._lifecycleRender = lifecycleRender;
    }

    public boolean isLifecycleResource() {
        return this._lifecycleResource;
    }

    public void setLifecycleResource(boolean lifecycleResource) {
        this._lifecycleResource = lifecycleResource;
    }

    public boolean isStateExclusive() {
        return this._stateExclusive;
    }

    public void setStateExclusive(boolean stateExclusive) {
        this._stateExclusive = stateExclusive;
    }

    public boolean isStateMaximized() {
        return this._stateMaximized;
    }

    public void setStateMaximized(boolean stateMaximized) {
        this._stateMaximized = stateMaximized;
    }

    public boolean isStatePopUp() {
        return this._statePopUp;
    }

    public void setStatePopUp(boolean statePopUp) {
        this._statePopUp = statePopUp;
    }

    public boolean isIsolated() {
        return this._isolated;
    }

    public void setIsolated(boolean isolated) {
        this._isolated = isolated;
    }

    public boolean isFacebook() {
        return this._facebook;
    }

    public String getFacebookCanvasPageURL() {
        return this._facebookCanvasPageURL;
    }

    public void setFacebookCanvasPageURL(String facebookCanvasPageURL) {
        this._facebookCanvasPageURL = facebookCanvasPageURL;
        if (Validator.isNotNull(facebookCanvasPageURL)) {
            this._facebook = true;
        }
    }

    public boolean isWidget() {
        return this._widget;
    }

    public void setWidget(boolean widget) {
        this._widget = widget;
    }

    public String getCDNHost() {
        return this._cdnHost;
    }

    public void setCDNHost(String cdnHost) {
        this._cdnHost = cdnHost;
    }

    public String getPortalURL() {
        return this._portalURL;
    }

    public void setPortalURL(String portalURL) {
        this._portalURL = portalURL;
    }

    public String getPathApplet() {
        return this._pathApplet;
    }

    public void setPathApplet(String pathApplet) {
        this._pathApplet = pathApplet;
    }

    public String getPathCms() {
        return this._pathCms;
    }

    public void setPathCms(String pathCms) {
        this._pathCms = pathCms;
    }

    public String getPathColorSchemeImages() {
        return this._pathColorSchemeImages;
    }

    public void setPathColorSchemeImages(String pathColorSchemeImages) {
        this._pathColorSchemeImages = pathColorSchemeImages;
    }

    public String getPathContext() {
        return this._pathContext;
    }

    public void setPathContext(String pathContext) {
        this._pathContext = pathContext;
    }

    public String getPathFlash() {
        return this._pathFlash;
    }

    public void setPathFlash(String pathFlash) {
        this._pathFlash = pathFlash;
    }

    public String getPathFriendlyURLPrivateGroup() {
        return this._pathFriendlyURLPrivateGroup;
    }

    public void setPathFriendlyURLPrivateGroup(String pathFriendlyURLPrivateGroup) {
        this._pathFriendlyURLPrivateGroup = pathFriendlyURLPrivateGroup;
    }

    public String getPathFriendlyURLPrivateUser() {
        return this._pathFriendlyURLPrivateUser;
    }

    public void setPathFriendlyURLPrivateUser(String pathFriendlyURLPrivateUser) {
        this._pathFriendlyURLPrivateUser = pathFriendlyURLPrivateUser;
    }

    public String getPathFriendlyURLPublic() {
        return this._pathFriendlyURLPublic;
    }

    public void setPathFriendlyURLPublic(String pathFriendlyURLPublic) {
        this._pathFriendlyURLPublic = pathFriendlyURLPublic;
    }

    public String getPathImage() {
        return this._pathImage;
    }

    public void setPathImage(String pathImage) {
        if (this.isFacebook() && !pathImage.startsWith("http://") && !pathImage.startsWith("https://")) {
            pathImage = this.getPortalURL() + pathImage;
        }
        this._pathImage = pathImage;
    }

    public String getPathJavaScript() {
        return this._pathJavaScript;
    }

    public void setPathJavaScript(String pathJavaScript) {
        this._pathJavaScript = pathJavaScript;
    }

    public String getPathMain() {
        return this._pathMain;
    }

    public void setPathMain(String pathMain) {
        this._pathMain = pathMain;
    }

    public String getPathSound() {
        return this._pathSound;
    }

    public void setPathSound(String pathSound) {
        this._pathSound = pathSound;
    }

    public String getPathThemeCss() {
        return this._pathThemeCss;
    }

    public void setPathThemeCss(String pathThemeCss) {
        this._pathThemeCss = pathThemeCss;
    }

    public String getPathThemeImage() {
        return this.getPathThemeImages();
    }

    public String getPathThemeImages() {
        return this._pathThemeImages;
    }

    public void setPathThemeImages(String pathThemeImages) {
        this._pathThemeImages = pathThemeImages;
    }

    public String getPathThemeJavaScript() {
        return this._pathThemeJavaScript;
    }

    public void setPathThemeJavaScript(String pathThemeJavaScript) {
        this._pathThemeJavaScript = pathThemeJavaScript;
    }

    public String getPathThemeRoot() {
        return this._pathThemeRoot;
    }

    public void setPathThemeRoot(String pathThemeRoot) {
        this._pathThemeRoot = pathThemeRoot;
    }

    public String getPathThemeTemplates() {
        return this._pathThemeTemplates;
    }

    public void setPathThemeTemplates(String pathThemeTemplates) {
        this._pathThemeTemplates = pathThemeTemplates;
    }

    public boolean isShowAddContentIcon() {
        return this._showAddContentIcon;
    }

    public void setShowAddContentIcon(boolean showAddContentIcon) {
        this._showAddContentIcon = showAddContentIcon;
    }

    public boolean isShowAddContentIconPermission() {
        return this._showAddContentIconPermission;
    }

    public void setShowAddContentIconPermission(boolean showAddContentIconPermission) {
        this._showAddContentIconPermission = showAddContentIconPermission;
    }

    public boolean isShowControlPanelIcon() {
        return this._showControlPanelIcon;
    }

    public void setShowControlPanelIcon(boolean showControlPanelIcon) {
        this._showControlPanelIcon = showControlPanelIcon;
    }

    public boolean isShowHomeIcon() {
        return this._showHomeIcon;
    }

    public void setShowHomeIcon(boolean showHomeIcon) {
        this._showHomeIcon = showHomeIcon;
    }

    public boolean isShowLayoutTemplatesIcon() {
        return this._showLayoutTemplatesIcon;
    }

    public void setShowLayoutTemplatesIcon(boolean showLayoutTemplatesIcon) {
        this._showLayoutTemplatesIcon = showLayoutTemplatesIcon;
    }

    public boolean isShowMyAccountIcon() {
        return this._showMyAccountIcon;
    }

    public void setShowMyAccountIcon(boolean showMyAccountIcon) {
        this._showMyAccountIcon = showMyAccountIcon;
    }

    public boolean isShowPageSettingsIcon() {
        return this._showPageSettingsIcon;
    }

    public void setShowPageSettingsIcon(boolean showPageSettingsIcon) {
        this._showPageSettingsIcon = showPageSettingsIcon;
    }

    public boolean isShowPortalIcon() {
        return this._showPortalIcon;
    }

    public void setShowPortalIcon(boolean showPortalIcon) {
        this._showPortalIcon = showPortalIcon;
    }

    public boolean isShowSignInIcon() {
        return this._showSignInIcon;
    }

    public void setShowSignInIcon(boolean showSignInIcon) {
        this._showSignInIcon = showSignInIcon;
    }

    public boolean isShowSignOutIcon() {
        return this._showSignOutIcon;
    }

    public void setShowSignOutIcon(boolean showSignOutIcon) {
        this._showSignOutIcon = showSignOutIcon;
    }

    public boolean isShowStagingIcon() {
        return this._showStagingIcon;
    }

    public void setShowStagingIcon(boolean showStagingIcon) {
        this._showStagingIcon = showStagingIcon;
    }

    public String getURLAddContent() {
        return this._urlAddContent;
    }

    public void setURLAddContent(String urlAddContent) {
        this._urlAddContent = urlAddContent;
    }

    public String getURLControlPanel() {
        return this._urlControlPanel;
    }

    public void setURLControlPanel(String urlControlPanel) {
        this._urlControlPanel = urlControlPanel;
    }

    public PortletURL getURLCreateAccount() {
        return this._urlCreateAccount;
    }

    public void setURLCreateAccount(PortletURL urlCreateAccount) {
        this._urlCreateAccount = urlCreateAccount;
    }

    public String getURLCurrent() {
        return this._urlCurrent;
    }

    public void setURLCurrent(String urlCurrent) {
        this._urlCurrent = urlCurrent;
    }

    public String getURLHome() {
        return this._urlHome;
    }

    public void setURLHome(String urlHome) {
        this._urlHome = urlHome;
    }

    public String getURLLayoutTemplates() {
        return this._urlLayoutTemplates;
    }

    public void setURLLayoutTemplates(String urlLayoutTemplates) {
        this._urlLayoutTemplates = urlLayoutTemplates;
    }

    public PortletURL getURLMyAccount() {
        return this._urlMyAccount;
    }

    public void setURLMyAccount(PortletURL urlMyAccount) {
        this._urlMyAccount = urlMyAccount;
    }

    public PortletURL getURLPageSettings() {
        return this._urlPageSettings;
    }

    public void setURLPageSettings(PortletURL urlPageSettings) {
        this._urlPageSettings = urlPageSettings;
    }

    public String getURLPortal() {
        return this._urlPortal;
    }

    public void setURLPortal(String urlPortal) {
        this._urlPortal = urlPortal;
    }

    public PortletURL getURLPublishToLive() {
        return this._urlPublishToLive;
    }

    public void setURLPublishToLive(PortletURL urlPublishToLive) {
        this._urlPublishToLive = urlPublishToLive;
    }

    public String getURLSignIn() {
        return this._urlSignIn;
    }

    public void setURLSignIn(String urlSignIn) {
        this._urlSignIn = urlSignIn;
    }

    public String getURLSignOut() {
        return this._urlSignOut;
    }

    public void setURLSignOut(String urlSignOut) {
        this._urlSignOut = urlSignOut;
    }

    public PortletURL getURLUpdateManager() {
        return this._urlUpdateManager;
    }

    public void setURLUpdateManager(PortletURL urlUpdateManager) {
        this._urlUpdateManager = urlUpdateManager;
    }

    public String getTilesTitle() {
        return this._tilesTitle;
    }

    public void setTilesTitle(String tilesTitle) {
        this._tilesTitle = tilesTitle;
    }

    public String getTilesContent() {
        return this._tilesContent;
    }

    public void setTilesContent(String tilesContent) {
        this._tilesContent = tilesContent;
    }

    public boolean isTilesSelectable() {
        return this._tilesSelectable;
    }

    public void setTilesSelectable(boolean tilesSelectable) {
        this._tilesSelectable = tilesSelectable;
    }

    public boolean isIncludePortletCssJs() {
        return this._includePortletCssJs;
    }

    public void setIncludePortletCssJs(boolean includePortletCssJs) {
        this._includePortletCssJs = includePortletCssJs;
    }

    public boolean isIncludeServiceJs() {
        return this._includeServiceJs;
    }

    public void setIncludeServiceJs(boolean includeServiceJs) {
        this._includeServiceJs = includeServiceJs;
    }

    public boolean isIncludedJs(String js) {
        String path = this.getPathJavaScript();
        if (this.isIncludePortletCssJs() && js.startsWith(path + "/liferay/portlet_css.js")) {
            return true;
        }
        return this.isIncludeServiceJs() && js.startsWith(path + "/liferay/service.js");
    }

    public PortletDisplay getPortletDisplay() {
        return this._portletDisplay;
    }

    public void recycle() {
        if (_log.isDebugEnabled()) {
            _log.debug("Recycling instance " + this.hashCode());
        }
        this._company = null;
        this._companyGroupId = 0L;
        this._companyLogo = "";
        this._companyLogoHeight = 0;
        this._companyLogoWidth = 0;
        this._realCompanyLogo = "";
        this._realCompanyLogoHeight = 0;
        this._realCompanyLogoWidth = 0;
        this._account = null;
        this._defaultUser = null;
        this._user = null;
        this._realUser = null;
        this._doAsUserId = "";
        this._doAsUserLanguageId = "";
        this._doAsGroupId = 0L;
        this._refererPlid = 0L;
        this._layoutSetLogo = "";
        this._layout = null;
        this._layouts = null;
        this._plid = 0L;
        this._layoutTypePortlet = null;
        this._scopeGroup = null;
        this._scopeGroupId = 0L;
        this._signedIn = false;
        this._permissionChecker = null;
        this._locale = null;
        this._languageId = null;
        this._i18n = false;
        this._i18nLanguageId = null;
        this._i18nPath = null;
        this._timeZone = null;
        this._theme = null;
        this._colorScheme = null;
        this._themeCssFastLoad = false;
        this._themeImagesFastLoad = false;
        this._themeJsBarebone = false;
        this._themeJsFastLoad = false;
        this._freeformLayout = false;
        this._serverName = "";
        this._serverPort = 0;
        this._secure = false;
        this._lifecycle = "";
        this._lifecycleAction = false;
        this._lifecycleRender = false;
        this._lifecycleResource = false;
        this._stateExclusive = false;
        this._stateMaximized = false;
        this._statePopUp = false;
        this._isolated = false;
        this._facebook = false;
        this._facebookCanvasPageURL = "";
        this._widget = false;
        this._cdnHost = "";
        this._portalURL = "";
        this._pathApplet = "";
        this._pathCms = "";
        this._pathColorSchemeImages = "";
        this._pathContext = "";
        this._pathFlash = "";
        this._pathFriendlyURLPrivateGroup = "";
        this._pathFriendlyURLPrivateUser = "";
        this._pathFriendlyURLPublic = "";
        this._pathImage = "";
        this._pathJavaScript = "";
        this._pathMain = "";
        this._pathSound = "";
        this._pathThemeCss = "";
        this._pathThemeImages = "";
        this._pathThemeJavaScript = "";
        this._pathThemeRoot = "";
        this._pathThemeTemplates = "";
        this._showAddContentIcon = false;
        this._showAddContentIconPermission = false;
        this._showControlPanelIcon = false;
        this._showHomeIcon = false;
        this._showLayoutTemplatesIcon = false;
        this._showMyAccountIcon = false;
        this._showPageSettingsIcon = false;
        this._showPortalIcon = false;
        this._showSignInIcon = false;
        this._showSignOutIcon = false;
        this._showStagingIcon = false;
        this._urlAddContent = "";
        this._urlControlPanel = "";
        this._urlCreateAccount = null;
        this._urlCurrent = "";
        this._urlHome = "";
        this._urlLayoutTemplates = "";
        this._urlMyAccount = null;
        this._urlPageSettings = null;
        this._urlPortal = "";
        this._urlPublishToLive = null;
        this._urlSignIn = "";
        this._urlSignOut = "";
        this._urlUpdateManager = null;
        this._tilesTitle = "";
        this._tilesContent = "";
        this._tilesSelectable = false;
        this._includePortletCssJs = false;
        this._includeServiceJs = false;
        this._portletDisplay.recycle();
    }
}

