/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import java.util.Date;
import javax.portlet.PortletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetEntryQuery {
    public static String[] ORDER_BY_COLUMNS = new String[]{"title", "createDate", "modifiedDate", "publishDate", "expirationDate", "priority", "viewCount"};
    private static Log _log = LogFactoryUtil.getLog(AssetEntryQuery.class);
    private long[] _allCategoryIds = new long[0];
    private long[] _allTagIds = new long[0];
    private long[] _anyCategoryIds = new long[0];
    private long[] _anyTagIds = new long[0];
    private long[] _classNameIds = new long[0];
    private int _end = -1;
    private boolean _excludeZeroViewCount;
    private Date _expirationDate;
    private long[] _groupIds = new long[0];
    private long[] _notAllCategoryIds = new long[0];
    private long[] _notAllTagIds = new long[0];
    private long[] _notAnyCategoryIds = new long[0];
    private long[] _notAnyTagIds = new long[0];
    private String _orderByCol1;
    private String _orderByCol2;
    private String _orderByType1;
    private String _orderByType2;
    private Date _publishDate;
    private int _start = -1;
    private Boolean _visible = Boolean.TRUE;

    public static String checkOrderByCol(String orderByCol) {
        if (orderByCol == null) {
            return ORDER_BY_COLUMNS[2];
        }
        for (int i = 0; i < ORDER_BY_COLUMNS.length; ++i) {
            if (!orderByCol.equals(ORDER_BY_COLUMNS[i])) continue;
            return orderByCol;
        }
        return ORDER_BY_COLUMNS[2];
    }

    public static String checkOrderByType(String orderByType) {
        if (orderByType == null || orderByType.equalsIgnoreCase("DESC")) {
            return "DESC";
        }
        return "ASC";
    }

    public AssetEntryQuery() {
        Date now;
        this._expirationDate = now = new Date();
        this._publishDate = now;
    }

    public AssetEntryQuery(long[] classNameIds, SearchContainer<?> searchContainer) throws PortalException, SystemException {
        this();
        String tagName;
        this.setClassNameIds(classNameIds);
        this._start = searchContainer.getStart();
        this._end = searchContainer.getEnd();
        PortletRequest portletRequest = searchContainer.getPortletRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        this._groupIds = new long[]{themeDisplay.getScopeGroupId()};
        long categoryId = ParamUtil.getLong(portletRequest, "categoryId");
        if (categoryId > 0L) {
            this._allCategoryIds = new long[]{categoryId};
        }
        if (Validator.isNotNull(tagName = ParamUtil.getString(portletRequest, "tag"))) {
            this._allTagIds = AssetTagLocalServiceUtil.getTagIds(this._groupIds[0], new String[]{tagName});
        }
    }

    public AssetEntryQuery(String className, SearchContainer<?> searchContainer) throws PortalException, SystemException {
        this(new long[]{PortalUtil.getClassNameId(className)}, searchContainer);
    }

    public long[] getAllCategoryIds() {
        return this._allCategoryIds;
    }

    public long[] getAllLeftAndRightCategoryIds() {
        return this._getLeftAndRightCategoryIds(this._allCategoryIds);
    }

    public long[] getAllTagIds() {
        return this._allTagIds;
    }

    public long[] getAnyCategoryIds() {
        return this._anyCategoryIds;
    }

    public long[] getAnyLeftAndRightCategoryIds() {
        return this._getLeftAndRightCategoryIds(this._anyCategoryIds);
    }

    public long[] getAnyTagIds() {
        return this._anyTagIds;
    }

    public long[] getClassNameIds() {
        return this._classNameIds;
    }

    public int getEnd() {
        return this._end;
    }

    public Date getExpirationDate() {
        return this._expirationDate;
    }

    public long[] getGroupIds() {
        return this._groupIds;
    }

    public long[] getNotAllCategoryIds() {
        return this._notAllCategoryIds;
    }

    public long[] getNotAllLeftAndRightCategoryIds() {
        return this._getLeftAndRightCategoryIds(this._notAllCategoryIds);
    }

    public long[] getNotAllTagIds() {
        return this._notAllTagIds;
    }

    public long[] getNotAnyCategoryIds() {
        return this._notAnyCategoryIds;
    }

    public long[] getNotAnyLeftAndRightCategoryIds() {
        return this._getLeftAndRightCategoryIds(this._notAnyCategoryIds);
    }

    public long[] getNotAnyTagIds() {
        return this._notAnyTagIds;
    }

    public String getOrderByCol1() {
        return AssetEntryQuery.checkOrderByCol(this._orderByCol1);
    }

    public String getOrderByCol2() {
        return AssetEntryQuery.checkOrderByCol(this._orderByCol2);
    }

    public String getOrderByType1() {
        return AssetEntryQuery.checkOrderByType(this._orderByType1);
    }

    public String getOrderByType2() {
        return AssetEntryQuery.checkOrderByType(this._orderByType2);
    }

    public Date getPublishDate() {
        return this._publishDate;
    }

    public int getStart() {
        return this._start;
    }

    public boolean isExcludeZeroViewCount() {
        return this._excludeZeroViewCount;
    }

    public Boolean isVisible() {
        return this._visible;
    }

    public void setAllCategoryIds(long[] allCategoryIds) {
        this._allCategoryIds = allCategoryIds;
    }

    public void setAllTagIds(long[] allTagIds) {
        this._allTagIds = allTagIds;
    }

    public void setAnyCategoryIds(long[] anyCategoryIds) {
        this._anyCategoryIds = anyCategoryIds;
    }

    public void setAnyTagIds(long[] anyTagIds) {
        this._anyTagIds = anyTagIds;
    }

    public void setClassName(String className) {
        long classNameId = PortalUtil.getClassNameId(className);
        this._classNameIds = new long[]{classNameId};
    }

    public void setClassNameIds(long[] classNameIds) {
        this._classNameIds = classNameIds;
    }

    public void setEnd(int end) {
        this._end = end;
    }

    public void setExcludeZeroViewCount(boolean excludeZeroViewCount) {
        this._excludeZeroViewCount = excludeZeroViewCount;
    }

    public void setExpirationDate(Date expirationDate) {
        this._expirationDate = expirationDate;
    }

    public void setGroupIds(long[] groupIds) {
        this._groupIds = groupIds;
    }

    public void setNotAllCategoryIds(long[] notAllCategoryIds) {
        this._notAllCategoryIds = notAllCategoryIds;
    }

    public void setNotAllTagIds(long[] notAllTagIds) {
        this._notAllTagIds = notAllTagIds;
    }

    public void setNotAnyCategoryIds(long[] notAnyCategoryIds) {
        this._notAnyCategoryIds = notAnyCategoryIds;
    }

    public void setNotAnyTagIds(long[] notAnyTagIds) {
        this._notAnyTagIds = notAnyTagIds;
    }

    public void setOrderByCol1(String orderByCol1) {
        this._orderByCol1 = orderByCol1;
    }

    public void setOrderByCol2(String orderByCol2) {
        this._orderByCol2 = orderByCol2;
    }

    public void setOrderByType1(String orderByType1) {
        this._orderByType1 = orderByType1;
    }

    public void setOrderByType2(String orderByType2) {
        this._orderByType2 = orderByType2;
    }

    public void setPublishDate(Date publishDate) {
        this._publishDate = publishDate;
    }

    public void setStart(int start) {
        this._start = start;
    }

    public void setVisible(Boolean visible) {
        this._visible = visible;
    }

    private long[] _getLeftAndRightCategoryIds(long[] categoryIds) {
        long[] leftRightIds = new long[categoryIds.length * 2];
        for (int i = 0; i < categoryIds.length; ++i) {
            long categoryId = categoryIds[i];
            try {
                AssetCategory category = AssetCategoryLocalServiceUtil.getCategory(categoryId);
                leftRightIds[2 * i] = category.getLeftCategoryId();
                leftRightIds[2 * i + 1] = category.getRightCategoryId();
                continue;
            }
            catch (Exception e) {
                _log.warn("Error retrieving category " + categoryId);
            }
        }
        return leftRightIds;
    }
}

