/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DLUtil {
    private static final String _DEFAULT_GENERIC_NAME = "default";
    private static final String _DEFAULT_FILE_ICON = "page";
    private static Log _log = LogFactoryUtil.getLog(DLUtil.class);
    private static DLUtil _instance = new DLUtil();
    private Map<String, String> _genericNames;
    private Set<String> _fileIcons = new HashSet<String>();

    public static void addPortletBreadcrumbEntries(DLFileEntry fileEntry, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        DLFolder folder = fileEntry.getFolder();
        DLUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view_file_entry");
        portletURL.setParameter("folderId", String.valueOf(fileEntry.getFolderId()));
        portletURL.setParameter("name", fileEntry.getName());
        PortalUtil.addPortletBreadcrumbEntry(request, fileEntry.getTitle(), portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(DLFileShortcut fileShortcut, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        DLFolder folder = fileShortcut.getFolder();
        DLUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view_file_shortcut");
        portletURL.setParameter("fileShortcutId", String.valueOf(fileShortcut.getFileShortcutId()));
        PortalUtil.addPortletBreadcrumbEntry(request, fileShortcut.getToTitle(), portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (folderId != 0L) {
            DLFolder folder = DLFolderLocalServiceUtil.getFolder(folderId);
            DLUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
    }

    public static void addPortletBreadcrumbEntries(DLFolder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString(request, "struts_action");
        long groupId = ParamUtil.getLong(request, "groupId");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (strutsAction.equals("/journal/select_document_library") || strutsAction.equals("/document_library/select_file_entry") || strutsAction.equals("/document_library/select_folder")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            portletURL.setParameter("struts_action", strutsAction);
            portletURL.setParameter("groupId", String.valueOf(groupId));
            PortalUtil.addPortletBreadcrumbEntry(request, themeDisplay.translate("document-home"), portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/document_library/view");
        }
        List<DLFolder> ancestorFolders = folder.getAncestors();
        Collections.reverse(ancestorFolders);
        for (DLFolder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            PortalUtil.addPortletBreadcrumbEntry(request, ancestorFolder.getName(), portletURL.toString());
        }
        portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
        PortalUtil.addPortletBreadcrumbEntry(request, folder.getName(), portletURL.toString());
    }

    public static int compareVersions(String version1, String version2) {
        int[] splitVersion1 = StringUtil.split(version1, ".", 0);
        int[] splitVersion2 = StringUtil.split(version2, ".", 0);
        if (splitVersion1.length != 2 && splitVersion2.length != 2) {
            return 0;
        }
        if (splitVersion1.length != 2) {
            return -1;
        }
        if (splitVersion2.length != 2) {
            return 1;
        }
        if (splitVersion1[0] > splitVersion2[0]) {
            return 1;
        }
        if (splitVersion1[0] < splitVersion2[0]) {
            return -1;
        }
        if (splitVersion1[1] > splitVersion2[1]) {
            return 1;
        }
        if (splitVersion1[1] < splitVersion2[1]) {
            return -1;
        }
        return 0;
    }

    public static String getFileIcon(String title) {
        return _instance._getFileIcon(title);
    }

    public static String getGenericName(String extension) {
        return _instance._getGenericName(extension);
    }

    public static String getLockId(long groupId, long folderId, String name) {
        StringBundler sb = new StringBundler(5);
        sb.append(groupId);
        sb.append("#");
        sb.append(folderId);
        sb.append("#");
        sb.append(name);
        return sb.toString();
    }

    private DLUtil() {
        String[] fileIcons = null;
        try {
            fileIcons = PrefsPropsUtil.getStringArray("dl.file.icons", ",");
        }
        catch (Exception e) {
            _log.error(e, e);
            fileIcons = new String[]{""};
        }
        for (int i = 0; i < fileIcons.length; ++i) {
            if ("*".equals(fileIcons[i])) continue;
            String extension = fileIcons[i];
            extension = extension.substring(1, extension.length());
            this._fileIcons.add(extension);
        }
        this._genericNames = new HashMap<String, String>();
        this._genericNames.put("lar", "compressed");
        this._genericNames.put("rar", "compressed");
        this._genericNames.put("zip", "compressed");
        this._genericNames.put("doc", "document");
        this._genericNames.put("docx", "document");
        this._genericNames.put("rtf", "document");
        this._genericNames.put("odt", "document");
        this._genericNames.put("flv", "flash");
        this._genericNames.put("swf", "flash");
        this._genericNames.put("bmp", "image");
        this._genericNames.put("gif", "image");
        this._genericNames.put("jpeg", "image");
        this._genericNames.put("jpg", "image");
        this._genericNames.put("odg", "image");
        this._genericNames.put("png", "image");
        this._genericNames.put("svg", "image");
        this._genericNames.put("acc", "music");
        this._genericNames.put("mid", "music");
        this._genericNames.put("mp3", "music");
        this._genericNames.put("wav", "music");
        this._genericNames.put("wma", "music");
        this._genericNames.put("pdf", "pdf");
        this._genericNames.put("odp", "presentation");
        this._genericNames.put("ppt", "presentation");
        this._genericNames.put("pptx", "presentation");
        this._genericNames.put("csv", "spreadsheet");
        this._genericNames.put("ods", "spreadsheet");
        this._genericNames.put("xls", "spreadsheet");
        this._genericNames.put("xlsx", "spreadsheet");
        this._genericNames.put("avi", "video");
        this._genericNames.put("mov", "video");
        this._genericNames.put("mp4", "video");
        this._genericNames.put("mpg", "video");
        this._genericNames.put("qt", "video");
        this._genericNames.put("rm", "video");
        this._genericNames.put("wmv", "video");
    }

    private String _getFileIcon(String title) {
        String extension = FileUtil.getExtension(title);
        if (!this._fileIcons.contains(extension)) {
            extension = _DEFAULT_FILE_ICON;
        }
        return extension;
    }

    private String _getGenericName(String extension) {
        String genericName = this._genericNames.get(extension);
        if (genericName == null) {
            genericName = _DEFAULT_GENERIC_NAME;
        }
        return genericName;
    }
}

