/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.cal;

import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;

public class Duration
implements Cloneable,
Serializable {
    private int weeks;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int DAYS_PER_WEEK = 7;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int MILLIS_PER_DAY = 86400000;
    private static final int MILLIS_PER_WEEK = 604800000;

    public Duration() {
    }

    public Duration(int d, int h, int m, int s) {
        this.days = d;
        this.hours = h;
        this.minutes = m;
        this.seconds = s;
    }

    public Duration(int h, int m, int s) {
        this(0, h, m, s);
    }

    public Duration(int w) {
        this.weeks = w;
    }

    public void clear() {
        this.weeks = 0;
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public void setWeeks(int w) {
        if (w < 0) {
            throw new IllegalArgumentException("Week value out of range");
        }
        this.checkWeeksOkay(w);
        this.weeks = w;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("Day value out of range");
        }
        this.checkNonWeeksOkay(d);
        this.days = d;
        this.normalize();
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int h) {
        if (h < 0) {
            throw new IllegalArgumentException("Hour value out of range");
        }
        this.checkNonWeeksOkay(h);
        this.hours = h;
        this.normalize();
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int m) {
        if (m < 0) {
            throw new IllegalArgumentException("Minute value out of range");
        }
        this.checkNonWeeksOkay(m);
        this.minutes = m;
        this.normalize();
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int s) {
        if (s < 0) {
            throw new IllegalArgumentException("Second value out of range");
        }
        this.checkNonWeeksOkay(s);
        this.seconds = s;
        this.normalize();
    }

    public long getInterval() {
        return this.seconds * 1000 + this.minutes * 60000 + this.hours * 3600000 + this.days * 86400000 + this.weeks * 604800000;
    }

    public void setInterval(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Negative-length interval");
        }
        this.clear();
        this.days = (int)(millis / 86400000L);
        this.seconds = (int)(millis % 86400000L / 1000L);
        this.normalize();
    }

    protected void normalize() {
        this.minutes += this.seconds / 60;
        this.seconds %= 60;
        this.hours += this.minutes / 60;
        this.minutes %= 60;
        this.days += this.hours / 24;
        this.hours %= 24;
    }

    protected void checkWeeksOkay(int f) {
        if (f != 0 && (this.days != 0 || this.hours != 0 || this.minutes != 0 || this.seconds != 0)) {
            throw new IllegalStateException("Weeks and non-weeks are incompatible");
        }
    }

    protected void checkNonWeeksOkay(int f) {
        if (f != 0 && this.weeks != 0) {
            throw new IllegalStateException("Weeks and non-weeks are incompatible");
        }
    }

    public Object clone() {
        try {
            Duration other = (Duration)super.clone();
            other.weeks = this.weeks;
            other.days = this.days;
            other.hours = this.hours;
            other.minutes = this.minutes;
            other.seconds = this.seconds;
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBundler sb = new StringBundler(12);
        sb.append(this.getClass().getName());
        sb.append("[weeks=");
        sb.append(this.weeks);
        sb.append(",days=");
        sb.append(this.days);
        sb.append(",hours=");
        sb.append(this.hours);
        sb.append(",minutes=");
        sb.append(this.minutes);
        sb.append(",seconds=");
        sb.append(this.seconds);
        sb.append("]");
        return sb.toString();
    }
}

