/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.util.HtmlUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AutoEscapeBeanHandler
implements InvocationHandler,
Serializable {
    private Serializable _bean;

    public AutoEscapeBeanHandler(Object bean) {
        this._bean = (Serializable)bean;
    }

    public Object getBean() {
        return this._bean;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("set")) {
            throw new IllegalAccessException("Setter methods cannot be called on an escaped bean");
        }
        if (methodName.endsWith("isEscapedModel")) {
            return true;
        }
        if (methodName.endsWith("toEscapedModel")) {
            return proxy;
        }
        Object result = null;
        try {
            result = method.invoke((Object)this._bean, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        if (method.getAnnotation(AutoEscape.class) != null) {
            result = HtmlUtil.escape((String)result);
        }
        return result;
    }
}

