/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;

public abstract class BaseMessageStatusMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(BaseMessageStatusMessageListener.class);
    private MessageSender _responseSender;
    private SingleDestinationMessageSender _statusSender;

    public BaseMessageStatusMessageListener() {
    }

    public BaseMessageStatusMessageListener(SingleDestinationMessageSender statusSender, MessageSender responseSender) {
        this._statusSender = statusSender;
        this._responseSender = responseSender;
    }

    @Override
    public void receive(Message message) {
        MessageStatus messageStatus = new MessageStatus();
        messageStatus.startTimer();
        try {
            try {
                this.doReceive(message, messageStatus);
            }
            catch (Exception e) {
                _log.error("Unable to process request " + message.getDestinationName(), e);
                messageStatus.setException(e);
                messageStatus.stopTimer();
                this._statusSender.send(messageStatus);
            }
        }
        finally {
            messageStatus.stopTimer();
            this._statusSender.send(messageStatus);
        }
    }

    public void setResponseSender(MessageSender responseSender) {
        this._responseSender = responseSender;
    }

    public void setStatusSender(SingleDestinationMessageSender statusSender) {
        this._statusSender = statusSender;
    }

    protected abstract void doReceive(Message var1, MessageStatus var2) throws Exception;

    protected MessageSender getResponseSender() {
        return this._responseSender;
    }
}

