/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.PortletConfigurationLayoutUtil;
import com.liferay.portal.kernel.portlet.ResourceServingConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletConfigFactoryUtil;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ValidatorException;
import javax.servlet.ServletContext;

public class DefaultConfigurationAction
implements ConfigurationAction,
ResourceServingConfigurationAction {
    public static final String PREFERENCES_PREFIX = "preferences--";

    public String getLocalizedParameter(PortletRequest portletRequest, String name) {
        String languageId = ParamUtil.getString(portletRequest, "languageId");
        return this.getParameter(portletRequest, name.concat("_").concat(languageId));
    }

    public String getParameter(PortletRequest portletRequest, String name) {
        name = PREFERENCES_PREFIX.concat(name).concat("--");
        return ParamUtil.getString(portletRequest, name);
    }

    @Override
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, "cmd");
        if (!cmd.equals("update")) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UnicodeProperties properties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, PREFERENCES_PREFIX);
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, "portletResource");
        Layout layout = PortletConfigurationLayoutUtil.getLayout(themeDisplay);
        PortletPermissionUtil.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), layout, portletResource, "CONFIGURATION");
        PortletPreferences portletPreferences = actionRequest.getPreferences();
        for (Map.Entry entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            portletPreferences.setValue(name, value);
        }
        Map portletPreferencesMap = (Map)actionRequest.getAttribute("PORTLET_PREFERENCES_MAP");
        if (portletPreferencesMap != null) {
            for (Map.Entry entry : portletPreferencesMap.entrySet()) {
                String name = (String)entry.getKey();
                String[] values = (String[])entry.getValue();
                portletPreferences.setValues(name, values);
            }
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            try {
                portletPreferences.store();
            }
            catch (ValidatorException ve) {
                SessionErrors.add((PortletRequest)actionRequest, ValidatorException.class.getName(), (Object)ve);
                return;
            }
            SessionMessages.add((PortletRequest)actionRequest, String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".refreshPortlet", (Object)portletResource);
            SessionMessages.add((PortletRequest)actionRequest, String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".updatedConfiguration");
            String redirect = PortalUtil.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, "redirect"));
            if (Validator.isNotNull(redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
    }

    @Override
    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        PortletConfig selPortletConfig = this.getSelPortletConfig((PortletRequest)renderRequest);
        String configTemplate = selPortletConfig.getInitParameter("config-template");
        if (Validator.isNotNull(configTemplate)) {
            return configTemplate;
        }
        String configJSP = selPortletConfig.getInitParameter("config-jsp");
        if (Validator.isNotNull(configJSP)) {
            return configJSP;
        }
        return "/configuration.jsp";
    }

    @Override
    public void serveResource(PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
    }

    public void setPreference(PortletRequest portletRequest, String name, String value) {
        this.setPreference(portletRequest, name, new String[]{value});
    }

    public void setPreference(PortletRequest portletRequest, String name, String[] values) {
        HashMap<String, String[]> portletPreferencesMap = (HashMap<String, String[]>)portletRequest.getAttribute("PORTLET_PREFERENCES_MAP");
        if (portletPreferencesMap == null) {
            portletPreferencesMap = new HashMap<String, String[]>();
            portletRequest.setAttribute("PORTLET_PREFERENCES_MAP", portletPreferencesMap);
        }
        portletPreferencesMap.put(name, values);
    }

    protected PortletConfig getSelPortletConfig(PortletRequest portletRequest) throws SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletResource = ParamUtil.getString(portletRequest, "portletResource");
        Portlet selPortlet = PortletLocalServiceUtil.getPortletById(themeDisplay.getCompanyId(), portletResource);
        ServletContext servletContext = (ServletContext)portletRequest.getAttribute("CTX");
        PortletConfig selPortletConfig = PortletConfigFactoryUtil.create(selPortlet, servletContext);
        return selPortletConfig;
    }
}

