/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SpellCheckIndexWriter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import java.io.InputStream;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.util.List;

public abstract class BaseSpellCheckIndexWriter
implements SpellCheckIndexWriter {
    private static final String _PORTLET_SEPARATOR = "_PORTLET_";
    private static final String[] _SUPPORTED_LOCALES = StringUtil.split(PropsUtil.get("index.search.spell.checker.supported.locales"));
    private static Log _log = LogFactoryUtil.getLog(BaseSpellCheckIndexWriter.class);
    private int _querySuggestionMaxNGramLength = 50;

    @Override
    public void indexKeyword(SearchContext searchContext, float weight, String keywordType) throws SearchException {
        if (!keywordType.equals("querySuggestion") && !keywordType.equals("spellChecker")) {
            throw new IllegalArgumentException("Invalid keyword type " + keywordType);
        }
        long groupId = 0L;
        long[] groupIds = searchContext.getGroupIds();
        if (groupIds != null && groupIds.length > 0) {
            groupId = groupIds[1];
        }
        String keywordFieldName = "keywordSearch";
        String typeFieldValue = "querySuggestion";
        int maxNGramLength = this._querySuggestionMaxNGramLength;
        if (keywordType.equals("spellChecker")) {
            keywordFieldName = "spellCheckWord";
            typeFieldValue = "spellChecker";
            maxNGramLength = 0;
        }
        try {
            this.indexKeyword(searchContext.getCompanyId(), groupId, searchContext.getLanguageId(), searchContext.getKeywords(), weight, keywordFieldName, typeFieldValue, maxNGramLength);
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void indexQuerySuggestionDictionaries(SearchContext searchContext) throws SearchException {
        try {
            String[] stringArray = _SUPPORTED_LOCALES;
            int n = _SUPPORTED_LOCALES.length;
            int n2 = 0;
            while (n2 < n) {
                String languageId = stringArray[n2];
                this.indexKeywords(searchContext.getCompanyId(), languageId, "index.search.query.suggestion.dictionary", "keywordSearch", "querySuggestion", this._querySuggestionMaxNGramLength);
                ++n2;
            }
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void indexQuerySuggestionDictionary(SearchContext searchContext) throws SearchException {
        try {
            this.indexKeywords(searchContext.getCompanyId(), searchContext.getLanguageId(), "index.search.query.suggestion.dictionary", "keywordSearch", "querySuggestion", this._querySuggestionMaxNGramLength);
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void indexSpellCheckerDictionaries(SearchContext searchContext) throws SearchException {
        try {
            String[] stringArray = _SUPPORTED_LOCALES;
            int n = _SUPPORTED_LOCALES.length;
            int n2 = 0;
            while (n2 < n) {
                String languageId = stringArray[n2];
                this.indexKeywords(searchContext.getCompanyId(), languageId, "index.search.spell.checker.dictionary", "spellCheckWord", "spellChecker", 0);
                ++n2;
            }
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void indexSpellCheckerDictionary(SearchContext searchContext) throws SearchException {
        try {
            this.indexKeywords(searchContext.getCompanyId(), searchContext.getLanguageId(), "index.search.spell.checker.dictionary", "spellCheckWord", "spellChecker", 0);
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    public void setQuerySuggestionMaxNGramLength(int querySuggestionMaxNGramLength) {
        this._querySuggestionMaxNGramLength = querySuggestionMaxNGramLength;
    }

    protected URL getResource(String name) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URL url = contextClassLoader.getResource(name);
        if (url == null) {
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            url = portalClassLoader.getResource(name);
        }
        return url;
    }

    protected String getUID(long companyId, String languageId, String word, String ... parameters) {
        StringBundler uidSB = new StringBundler();
        uidSB.append(String.valueOf(companyId));
        uidSB.append("_");
        uidSB.append("3");
        uidSB.append(_PORTLET_SEPARATOR);
        int length = 4;
        if (parameters != null) {
            length += parameters.length;
        }
        try {
            CharsetEncoder charsetEncoder = CharsetEncoderUtil.getCharsetEncoder("UTF-8");
            StringBundler keySB = new StringBundler(length);
            keySB.append(languageId);
            keySB.append("_");
            keySB.append(word);
            keySB.append("_");
            keySB.append(StringUtil.toLowerCase(word));
            if (parameters != null) {
                String[] stringArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameter = stringArray[n2];
                    keySB.append(parameter);
                    keySB.append("_");
                    ++n2;
                }
            }
            String key = keySB.toString();
            byte[] bytes = DigesterUtil.digestRaw("MD5", charsetEncoder.encode(CharBuffer.wrap(key)));
            uidSB.append(Base64.encode(bytes));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return uidSB.toString();
    }

    protected abstract void indexKeyword(long var1, long var3, String var5, String var6, float var7, String var8, String var9, int var10) throws Exception;

    protected abstract void indexKeywords(long var1, long var3, String var5, InputStream var6, String var7, String var8, int var9) throws Exception;

    protected void indexKeywords(long companyId, long groupId, String languageId, String[] dictionaryFileNames, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws Exception {
        String[] stringArray = dictionaryFileNames;
        int n = dictionaryFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                InputStream inputStream;
                String dictionaryFileName;
                block9: {
                    block10: {
                        URL url;
                        block7: {
                            block8: {
                                dictionaryFileName = stringArray[n2];
                                inputStream = null;
                                if (_log.isInfoEnabled()) {
                                    _log.info("Start indexing dictionary for " + dictionaryFileName);
                                }
                                try {
                                    url = this.getResource(dictionaryFileName);
                                    if (url != null) break block7;
                                    if (!_log.isWarnEnabled()) break block8;
                                    _log.warn("Unable to read " + dictionaryFileName);
                                }
                                catch (Throwable throwable) {
                                    StreamUtil.cleanUp(inputStream);
                                    throw throwable;
                                }
                            }
                            StreamUtil.cleanUp(inputStream);
                            break block11;
                        }
                        inputStream = url.openStream();
                        if (inputStream != null) break block9;
                        if (!_log.isWarnEnabled()) break block10;
                        _log.warn("Unable to read " + dictionaryFileName);
                    }
                    StreamUtil.cleanUp(inputStream);
                    break block11;
                }
                this.indexKeywords(companyId, groupId, languageId, inputStream, keywordFieldName, typeFieldValue, maxNGramLength);
                StreamUtil.cleanUp(inputStream);
                if (_log.isInfoEnabled()) {
                    _log.info("Finished indexing dictionary for " + dictionaryFileName);
                }
            }
            ++n2;
        }
    }

    protected void indexKeywords(long companyId, String languageId, String propsKey, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws Exception {
        String[] dictionaryFileNames = PropsUtil.getArray(propsKey, new Filter(languageId));
        this.indexKeywords(companyId, 0L, languageId, dictionaryFileNames, keywordFieldName, typeFieldValue, maxNGramLength);
        List<Group> groups = GroupLocalServiceUtil.getLiveGroups();
        for (Group group : groups) {
            Object[] groupDictionaryFileNames = PropsUtil.getArray(propsKey, new Filter(languageId, String.valueOf(group.getGroupId())));
            if (ArrayUtil.isEmpty(groupDictionaryFileNames)) continue;
            this.indexKeywords(companyId, group.getGroupId(), languageId, (String[])groupDictionaryFileNames, keywordFieldName, typeFieldValue, maxNGramLength);
        }
    }
}

