/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsProcessor;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.ArrayUtil;

public class QuerySuggestionHitsProcessor
implements HitsProcessor {
    @Override
    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isQuerySuggestionEnabled()) {
            return true;
        }
        if (hits.getLength() >= queryConfig.getQuerySuggestionScoresThreshold()) {
            return true;
        }
        String[] querySuggestions = SearchEngineUtil.suggestKeywordQueries(searchContext, queryConfig.getQuerySuggestionMax());
        querySuggestions = ArrayUtil.remove(querySuggestions, searchContext.getKeywords());
        hits.setQuerySuggestions(querySuggestions);
        return true;
    }
}

