/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.CookieNotSupportedException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieKeys {
    public static final String COMPANY_ID = "COMPANY_ID";
    public static final String COOKIE_SUPPORT = "COOKIE_SUPPORT";
    public static final String GUEST_LANGUAGE_ID = "GUEST_LANGUAGE_ID";
    public static final String ID = "ID";
    public static final String JSESSIONID = "JSESSIONID";
    public static final String LOGIN = "LOGIN";
    public static final int MAX_AGE = 1471228928;
    public static final String PASSWORD = "PASSWORD";
    public static final String REMEMBER_ME = "REMEMBER_ME";
    public static final String REMOTE_PREFERENCE_PREFIX = "REMOTE_PREFERENCE_";
    public static final String SCREEN_NAME = "SCREEN_NAME";
    public static final String USER_UUID = "USER_UUID";
    private static final String _SESSION_COOKIE_DOMAIN = PropsUtil.get("session.cookie.domain");
    private static final boolean _SESSION_COOKIE_USE_FULL_HOSTNAME = GetterUtil.getBoolean(PropsUtil.get("session.cookie.use.full.hostname"));
    private static final boolean _SESSION_ENABLE_PERSISTENT_COOKIES = GetterUtil.getBoolean(PropsUtil.get("session.enable.persistent.cookies"));
    private static final boolean _SESSION_TEST_COOKIE_SUPPORT = GetterUtil.getBoolean(PropsUtil.get("session.test.cookie.support"));
    private static final boolean _TCK_URL = GetterUtil.getBoolean(PropsUtil.get("tck.url"));
    private static Log _log = LogFactoryUtil.getLog(CookieKeys.class);

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, Cookie cookie) {
        CookieKeys.addCookie(request, response, cookie, request.isSecure());
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, Cookie cookie, boolean secure) {
        String originalValue;
        if (!_SESSION_ENABLE_PERSISTENT_COOKIES || _TCK_URL) {
            return;
        }
        String name = cookie.getName();
        String encodedValue = originalValue = cookie.getValue();
        if (CookieKeys.isEncodedCookie(name)) {
            encodedValue = UnicodeFormatter.bytesToHex(originalValue.getBytes());
            if (_log.isDebugEnabled()) {
                _log.debug("Add encoded cookie " + name);
                _log.debug("Original value " + originalValue);
                _log.debug("Hex encoded value " + encodedValue);
            }
        }
        cookie.setSecure(secure);
        cookie.setValue(encodedValue);
        cookie.setVersion(0);
        response.addCookie(cookie);
    }

    public static void addSupportCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookieSupportCookie = new Cookie(COOKIE_SUPPORT, "true");
        cookieSupportCookie.setPath("/");
        cookieSupportCookie.setMaxAge(1471228928);
        CookieKeys.addCookie(request, response, cookieSupportCookie);
    }

    public static String getCookie(HttpServletRequest request, String name) {
        return CookieKeys.getCookie(request, name, true);
    }

    public static String getCookie(HttpServletRequest request, String name, boolean toUpperCase) {
        String value = CookieKeys._get(request, name, toUpperCase);
        if (value == null || !CookieKeys.isEncodedCookie(name)) {
            return value;
        }
        try {
            String encodedValue = value;
            String originalValue = new String(UnicodeFormatter.hexToBytes(encodedValue));
            if (_log.isDebugEnabled()) {
                _log.debug("Get encoded cookie " + name);
                _log.debug("Hex encoded value " + encodedValue);
                _log.debug("Original value " + originalValue);
            }
            return originalValue;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn(e.getMessage());
            }
            return value;
        }
    }

    public static String getDomain(HttpServletRequest request) {
        if (Validator.isNotNull(_SESSION_COOKIE_DOMAIN)) {
            return _SESSION_COOKIE_DOMAIN;
        }
        String host = request.getServerName();
        if (_SESSION_COOKIE_USE_FULL_HOSTNAME) {
            return "";
        }
        return CookieKeys.getDomain(host);
    }

    public static String getDomain(String host) {
        if (host == null) {
            return null;
        }
        if (Validator.isIPAddress(host)) {
            return host;
        }
        int x = host.lastIndexOf(46);
        if (x <= 0) {
            return null;
        }
        int y = host.lastIndexOf(46, x - 1);
        if (y <= 0) {
            return "." + host;
        }
        int z = host.lastIndexOf(46, y - 1);
        String domain = null;
        domain = z <= 0 ? host.substring(y) : host.substring(z);
        return domain;
    }

    public static boolean hasSessionId(HttpServletRequest request) {
        String jsessionid = CookieKeys.getCookie(request, JSESSIONID, false);
        return jsessionid != null;
    }

    public static boolean isEncodedCookie(String name) {
        return name.equals(ID) || name.equals(LOGIN) || name.equals(PASSWORD) || name.equals(SCREEN_NAME);
    }

    public static void validateSupportCookie(HttpServletRequest request) throws CookieNotSupportedException {
        String cookieSupport;
        if (_SESSION_ENABLE_PERSISTENT_COOKIES && _SESSION_TEST_COOKIE_SUPPORT && Validator.isNull(cookieSupport = CookieKeys.getCookie(request, COOKIE_SUPPORT, false))) {
            throw new CookieNotSupportedException();
        }
    }

    private static String _get(HttpServletRequest request, String name, boolean toUpperCase) {
        Cookie cookie;
        Map<String, Cookie> cookieMap = CookieKeys._getCookieMap(request);
        if (toUpperCase) {
            name = StringUtil.toUpperCase(name);
        }
        if ((cookie = cookieMap.get(name)) == null) {
            return null;
        }
        return cookie.getValue();
    }

    private static Map<String, Cookie> _getCookieMap(HttpServletRequest request) {
        Map<String, Cookie> cookieMap = (Map<String, Cookie>)request.getAttribute(CookieKeys.class.getName());
        if (cookieMap != null) {
            return cookieMap;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookieMap = Collections.emptyMap();
        } else {
            cookieMap = new HashMap<String, Cookie>(cookies.length * 4 / 3);
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                String cookieName = GetterUtil.getString(cookie.getName());
                cookieName = StringUtil.toUpperCase(cookieName);
                cookieMap.put(cookieName, cookie);
                ++n2;
            }
        }
        request.setAttribute(CookieKeys.class.getName(), cookieMap);
        return cookieMap;
    }
}

