/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class ServerDetector {
    public static final String GERONIMO_ID = "geronimo";
    public static final String GLASSFISH_ID = "glassfish";
    public static final String JBOSS_ID = "jboss";
    public static final String JETTY_ID = "jetty";
    public static final String JONAS_ID = "jonas";
    public static final String OC4J_ID = "oc4j";
    public static final String RESIN_ID = "resin";
    public static final String TOMCAT_ID = "tomcat";
    public static final String WEBLOGIC_ID = "weblogic";
    public static final String WEBSPHERE_ID = "websphere";
    private static Log _log = LogFactoryUtil.getLog(ServerDetector.class);
    private static ServerDetector _instance;
    private boolean _geronimo;
    private boolean _glassfish;
    private boolean _jBoss;
    private boolean _jBoss5;
    private boolean _jBoss7;
    private boolean _jetty;
    private boolean _jonas;
    private boolean _oc4j;
    private boolean _resin;
    private String _serverId;
    private boolean _supportsComet;
    private boolean _supportsHotDeploy;
    private boolean _tomcat;
    private boolean _webLogic;
    private boolean _webSphere;

    public static ServerDetector getInstance() {
        if (_instance == null) {
            _instance = new ServerDetector();
            _instance._init();
        }
        return _instance;
    }

    public static String getServerId() {
        return ServerDetector.getInstance()._serverId;
    }

    public static void init(String serverId) {
        ServerDetector serverDetector = new ServerDetector();
        serverDetector._serverId = serverId;
        if (serverId.equals(GERONIMO_ID)) {
            serverDetector._geronimo = true;
        } else if (serverId.equals(GLASSFISH_ID)) {
            serverDetector._glassfish = true;
        } else if (serverId.equals(JBOSS_ID)) {
            serverDetector._jBoss = true;
        } else if (serverId.equals(JETTY_ID)) {
            serverDetector._jetty = true;
        } else if (serverId.equals(JONAS_ID)) {
            serverDetector._jonas = true;
        } else if (serverId.equals(OC4J_ID)) {
            serverDetector._oc4j = true;
        } else if (serverId.equals(RESIN_ID)) {
            serverDetector._resin = true;
        } else if (serverId.equals(TOMCAT_ID)) {
            serverDetector._tomcat = true;
        } else if (serverId.equals(WEBLOGIC_ID)) {
            serverDetector._webLogic = true;
        } else if (serverId.equals(WEBSPHERE_ID)) {
            serverDetector._webSphere = true;
        } else {
            serverDetector._init();
        }
        _instance = serverDetector;
    }

    public static boolean isGeronimo() {
        return ServerDetector.getInstance()._geronimo;
    }

    public static boolean isGlassfish() {
        return ServerDetector.getInstance()._glassfish;
    }

    public static boolean isJBoss() {
        return ServerDetector.getInstance()._jBoss;
    }

    public static boolean isJBoss5() {
        return ServerDetector.getInstance()._jBoss5;
    }

    public static boolean isJBoss7() {
        return ServerDetector.getInstance()._jBoss7;
    }

    public static boolean isJetty() {
        return ServerDetector.getInstance()._jetty;
    }

    public static boolean isJOnAS() {
        return ServerDetector.getInstance()._jonas;
    }

    public static boolean isOC4J() {
        return ServerDetector.getInstance()._oc4j;
    }

    public static boolean isResin() {
        return ServerDetector.getInstance()._resin;
    }

    public static boolean isSupportsComet() {
        return ServerDetector.getInstance()._supportsComet;
    }

    public static boolean isSupportsHotDeploy() {
        return ServerDetector.getInstance()._supportsHotDeploy;
    }

    public static boolean isTomcat() {
        return ServerDetector.getInstance()._tomcat;
    }

    public static boolean isWebLogic() {
        return ServerDetector.getInstance()._webLogic;
    }

    public static boolean isWebSphere() {
        return ServerDetector.getInstance()._webSphere;
    }

    public static void setSupportsHotDeploy(boolean supportsHotDeploy) {
        ServerDetector.getInstance()._supportsHotDeploy = supportsHotDeploy;
        if (_log.isInfoEnabled()) {
            if (supportsHotDeploy) {
                _log.info("Server supports hot deploy");
            } else {
                _log.info("Server does not support hot deploy");
            }
        }
    }

    private boolean _detect(String className) {
        try {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            systemClassLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = this.getClass();
            return clazz.getResource(className) != null;
        }
    }

    private boolean _hasSystemProperty(String key) {
        String value = System.getProperty(key);
        return value != null;
    }

    private void _init() {
        if (this._isGeronimo()) {
            this._serverId = GERONIMO_ID;
            this._geronimo = true;
        } else if (this._isGlassfish()) {
            this._serverId = GLASSFISH_ID;
            this._glassfish = true;
        } else if (this._isJBoss()) {
            this._serverId = JBOSS_ID;
            this._jBoss = true;
            if (this._isJBoss5()) {
                this._jBoss5 = true;
            } else {
                this._jBoss7 = true;
            }
        } else if (this._isJOnAS()) {
            this._serverId = JONAS_ID;
            this._jonas = true;
        } else if (this._isOC4J()) {
            this._serverId = OC4J_ID;
            this._oc4j = true;
        } else if (this._isResin()) {
            this._serverId = RESIN_ID;
            this._resin = true;
        } else if (this._isWebLogic()) {
            this._serverId = WEBLOGIC_ID;
            this._webLogic = true;
        } else if (this._isWebSphere()) {
            this._serverId = WEBSPHERE_ID;
            this._webSphere = true;
        }
        if (this._serverId == null) {
            if (this._isJetty()) {
                this._serverId = JETTY_ID;
                this._jetty = true;
            } else if (this._isTomcat()) {
                this._serverId = TOMCAT_ID;
                this._tomcat = true;
            }
        }
        if (System.getProperty("external-properties") == null && _log.isInfoEnabled()) {
            if (this._serverId != null) {
                _log.info("Detected server " + this._serverId);
            } else {
                _log.info("No server detected");
            }
        }
    }

    private boolean _isGeronimo() {
        return this._hasSystemProperty("org.apache.geronimo.home.dir");
    }

    private boolean _isGlassfish() {
        return this._hasSystemProperty("com.sun.aas.instanceRoot");
    }

    private boolean _isJBoss() {
        return this._hasSystemProperty("jboss.home.dir");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _isJBoss5() {
        try {
            MBeanServer mBeanServer;
            String defaultDomain;
            Iterator<MBeanServer> iterator = MBeanServerFactory.findMBeanServer(null).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(defaultDomain = (mBeanServer = iterator.next()).getDefaultDomain()).equals(JBOSS_ID));
            ObjectName objectName = new ObjectName("jboss.system:type=Server");
            String version = (String)mBeanServer.getAttribute(objectName, "VersionNumber");
            if (!version.startsWith("5")) return false;
            return true;
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return false;
    }

    private boolean _isJetty() {
        return this._hasSystemProperty("jetty.home");
    }

    private boolean _isJOnAS() {
        return this._hasSystemProperty("jonas.base");
    }

    private boolean _isOC4J() {
        return this._detect("oracle.oc4j.util.ClassUtils");
    }

    private boolean _isResin() {
        return this._hasSystemProperty("resin.home");
    }

    private boolean _isTomcat() {
        return this._hasSystemProperty("catalina.base");
    }

    private boolean _isWebLogic() {
        return this._detect("/weblogic/Server.class");
    }

    private boolean _isWebSphere() {
        return this._detect("/com/ibm/websphere/product/VersionInfo.class");
    }
}

