/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringParserFragment {
    private static Pattern _defaultPattern = Pattern.compile("[^/\\.]+");
    private String _name;
    private Pattern _pattern;
    private boolean _raw;
    private String _token;

    public StringParserFragment(String chunk) {
        chunk = chunk.substring(1, chunk.length() - 1);
        if (Validator.isNull(chunk)) {
            throw new IllegalArgumentException("Fragment is null");
        }
        String[] chunkParts = chunk.split(":", 2);
        if (chunkParts.length == 2) {
            this._name = chunkParts[0];
            String pattern = chunkParts[1];
            if (Validator.isNull(pattern)) {
                throw new IllegalArgumentException("Pattern is null");
            }
            this._pattern = Pattern.compile(pattern);
        } else {
            this._name = chunkParts[0];
            this._pattern = _defaultPattern;
        }
        if (Validator.isNull(this._name)) {
            throw new IllegalArgumentException("Name is null");
        }
        if (this._name.startsWith("%")) {
            this._name = this._name.substring(1);
            if (Validator.isNull(this._name)) {
                throw new IllegalArgumentException("Name is null");
            }
            this._raw = true;
        }
        this._token = "{".concat(this._name).concat("}");
    }

    public String getName() {
        return this._name;
    }

    public String getPattern() {
        return this._pattern.toString();
    }

    public String getToken() {
        return this._token;
    }

    public boolean isRaw() {
        return this._raw;
    }

    public boolean matches(String parameter) {
        Matcher matcher = this._pattern.matcher(parameter);
        return matcher.matches();
    }
}

