/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;

public class PrincipalBean {
    public static final String[] ANONYMOUS_NAMES = new String[]{"anonymous-guest", "guest", "ANONYMOUS", "<anonymous>"};
    public static final String JRUN_ANONYMOUS = "anonymous-guest";
    public static final String ORACLE_ANONYMOUS = "guest";
    public static final String SUN_ANONYMOUS = "ANONYMOUS";
    public static final String WEBLOGIC_ANONYMOUS = "<anonymous>";

    public User getGuestOrUser() throws PortalException, SystemException {
        try {
            return this.getUser();
        }
        catch (PrincipalException pe) {
            try {
                return UserLocalServiceUtil.getDefaultUser(CompanyThreadLocal.getCompanyId());
            }
            catch (Exception exception) {
                throw pe;
            }
        }
    }

    public long getGuestOrUserId() throws PrincipalException {
        try {
            return this.getUserId();
        }
        catch (PrincipalException pe) {
            try {
                return UserLocalServiceUtil.getDefaultUserId(CompanyThreadLocal.getCompanyId());
            }
            catch (Exception exception) {
                throw pe;
            }
        }
    }

    public PermissionChecker getPermissionChecker() throws PrincipalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            throw new PrincipalException("PermissionChecker not initialized");
        }
        return permissionChecker;
    }

    public User getUser() throws PortalException, SystemException {
        return UserLocalServiceUtil.getUserById(this.getUserId());
    }

    public long getUserId() throws PrincipalException {
        String name = PrincipalThreadLocal.getName();
        if (name == null) {
            throw new PrincipalException();
        }
        if (Validator.isNull(name)) {
            throw new PrincipalException("Principal is null");
        }
        int i = 0;
        while (i < ANONYMOUS_NAMES.length) {
            if (StringUtil.equalsIgnoreCase(name, ANONYMOUS_NAMES[i])) {
                throw new PrincipalException("Principal cannot be " + ANONYMOUS_NAMES[i]);
            }
            ++i;
        }
        return GetterUtil.getLong(name);
    }
}

