/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;

public abstract class BaseAssetRendererFactory
implements AssetRendererFactory {
    private static final boolean _LINKABLE = false;
    private static final boolean _PERMISSION = true;
    private static final boolean _SELECTABLE = true;
    private static final String[] _SELECTABLE_DDM_STRUCTURE_FIELDS = new String[]{"checkbox", "ddm-date", "ddm-decimal", "ddm-integer", "ddm-number", "radio", "select", "text"};
    private String _className;
    private String _portletId;

    @Override
    public AssetEntry getAssetEntry(long assetEntryId) throws PortalException, SystemException {
        return AssetEntryLocalServiceUtil.getEntry(assetEntryId);
    }

    @Override
    public AssetEntry getAssetEntry(String className, long classPK) throws PortalException, SystemException {
        return AssetEntryLocalServiceUtil.getEntry(className, classPK);
    }

    @Override
    public AssetRenderer getAssetRenderer(long classPK) throws PortalException, SystemException {
        return this.getAssetRenderer(classPK, 1);
    }

    @Override
    public AssetRenderer getAssetRenderer(long groupId, String urlTitle) throws PortalException, SystemException {
        return null;
    }

    @Override
    public long getClassNameId() {
        return PortalUtil.getClassNameId(this._className);
    }

    @Override
    public List<Tuple> getClassTypeFieldNames(long classTypeId, Locale locale, int start, int end) throws Exception {
        return Collections.emptyList();
    }

    @Override
    public int getClassTypeFieldNamesCount(long classTypeId, Locale locale) throws Exception {
        return 0;
    }

    @Override
    public Map<Long, String> getClassTypes(long[] groupId, Locale locale) throws Exception {
        return Collections.emptyMap();
    }

    @Override
    public String getIconPath(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getIconPath(themeDisplay);
    }

    @Override
    public String getPortletId() {
        return this._portletId;
    }

    @Override
    public String getTypeName(Locale locale, boolean hasSubtypes) {
        return ResourceActionsUtil.getModelResource(locale, this.getClassName());
    }

    @Override
    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException, SystemException {
        return null;
    }

    @Override
    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws PortalException, SystemException {
        return null;
    }

    @Override
    public boolean hasClassTypeFieldNames(long classTypeId, Locale locale) throws Exception {
        List<Tuple> classTypeFieldNames = this.getClassTypeFieldNames(classTypeId, locale, -1, -1);
        return !classTypeFieldNames.isEmpty();
    }

    @Override
    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return true;
    }

    @Override
    public boolean isActive(long companyId) {
        if (Validator.isNull(this.getPortletId())) {
            return true;
        }
        Portlet portlet = null;
        try {
            portlet = PortletLocalServiceUtil.getPortletById(companyId, this.getPortletId());
        }
        catch (SystemException systemException) {
            portlet = PortletLocalServiceUtil.getPortletById(this.getPortletId());
        }
        if (portlet == null) {
            return false;
        }
        return portlet.isActive();
    }

    @Override
    public boolean isCategorizable() {
        return true;
    }

    @Override
    public boolean isLinkable() {
        return false;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void setClassName(String className) {
        this._className = className;
    }

    @Override
    public void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    protected long getControlPanelPlid(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return PortalUtil.getControlPanelPlid(themeDisplay.getCompanyId());
    }

    protected List<Tuple> getDDMStructureFieldNames(DDMStructure ddmStructure, Locale locale) throws Exception {
        ArrayList<Tuple> fields = new ArrayList<Tuple>();
        Map<String, Map<String, String>> fieldsMap = ddmStructure.getFieldsMap(LocaleUtil.toLanguageId(locale));
        for (Map<String, String> fieldMap : fieldsMap.values()) {
            String indexType = fieldMap.get("indexType");
            boolean privateField = GetterUtil.getBoolean(fieldMap.get("private"));
            String type = fieldMap.get("type");
            if (Validator.isNull(indexType) || privateField || !ArrayUtil.contains(_SELECTABLE_DDM_STRUCTURE_FIELDS, type)) continue;
            String label = fieldMap.get("label");
            String name = fieldMap.get("name");
            fields.add(new Tuple(label, name, type, ddmStructure.getStructureId()));
        }
        return fields;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/page.png";
    }
}

